/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.unity;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.util.Ut;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Objects;

class Where {
    Where() {
    }

    static JsonObject whereDay(JsonObject filters, String field, Instant instant) {
        if (Ut.notNil((String)field) && Objects.nonNull(instant)) {
            LocalDateTime current = Ut.toDateTime((Instant)instant);
            LocalDateTime begin = LocalDateTime.of(current.toLocalDate(), LocalTime.MIN);
            LocalDateTime end = LocalDateTime.of(current.toLocalDate(), LocalTime.MAX);
            JsonObject condition = new JsonObject();
            condition.put(field + ",<", (Object)Ut.parse((LocalDateTime)end).toInstant());
            condition.put(field + ",>", (Object)Ut.parse((LocalDateTime)begin).toInstant());
            condition.put("", (Object)Boolean.TRUE);
            filters.put("$" + field, (Object)condition);
        }
        return filters;
    }

    static JsonObject whereAnd() {
        return new JsonObject().put("", (Object)Boolean.TRUE);
    }

    static JsonObject whereOr() {
        return new JsonObject().put("", (Object)Boolean.FALSE);
    }

    static JsonObject whereKeys(JsonArray keys) {
        JsonObject criteria = Where.whereAnd();
        criteria.put("key,i", (Object)keys);
        return criteria;
    }

    static JsonObject whereQrA(JsonObject qr, String field, Object value) {
        Objects.requireNonNull(qr);
        if (value instanceof JsonObject) {
            JsonObject query = qr.copy();
            JsonObject original = query.getJsonObject("criteria");
            if (Ut.notNil((JsonObject)original)) {
                JsonObject criteria = new JsonObject();
                criteria.put("$Or$", (Object)original.copy());
                criteria.put(field, value);
                if (!criteria.containsKey("")) {
                    criteria.put("", (Object)Boolean.TRUE);
                }
                query.put("criteria", (Object)criteria);
            } else {
                query.put("criteria", value);
            }
            return query;
        }
        JsonObject query = qr.copy();
        if (!query.containsKey("criteria")) {
            query.put("criteria", (Object)new JsonObject());
        }
        JsonObject criteria = query.getJsonObject("criteria");
        criteria.put(field, value);
        if (!criteria.containsKey("")) {
            criteria.put("", (Object)Boolean.TRUE);
        }
        query.put("criteria", (Object)criteria);
        return query;
    }
}

