/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.verticle;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.up.annotations.Worker;
import io.vertx.up.atom.worker.Mission;
import io.vertx.up.eon.em.JobType;
import io.vertx.up.log.Annal;
import io.vertx.up.log.Debugger;
import io.vertx.up.uca.job.center.Agha;
import io.vertx.up.uca.job.store.JobConfig;
import io.vertx.up.uca.job.store.JobPin;
import io.vertx.up.uca.job.store.JobStore;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;

@Worker(instances=1)
public class ZeroScheduler
extends AbstractVerticle {
    private static final Annal LOGGER = Annal.get(ZeroScheduler.class);
    private static final JobStore STORE = JobPin.getStore();

    public void start() {
        JobConfig config = JobPin.getConfig();
        if (Objects.nonNull(config)) {
            Set<Mission> missions = STORE.fetch();
            if (missions.isEmpty()) {
                LOGGER.info("Zero system detect no jobs, the scheduler will be stopped.", new Object[0]);
            } else {
                LOGGER.info("Zero system detect {0} jobs, the scheduler will begin....", new Object[]{missions.size()});
                ArrayList futures = new ArrayList();
                missions.forEach(mission -> futures.add(this.start((Mission)mission)));
                Ux.thenCombineT(futures).onSuccess(nil -> LOGGER.info("[ Job ] All Job schedulers have been started!!!", new Object[0]));
            }
        } else {
            LOGGER.info("( Ignore ) Because there is no definition in `vertx-job.yml`, Job container is stop....", new Object[0]);
        }
    }

    private Future<Void> start(Mission mission) {
        Agha agha;
        Object reference = mission.getProxy();
        if (Objects.nonNull(reference)) {
            Ut.contract((Object)reference, Vertx.class, (Object)this.vertx);
        }
        if (Objects.nonNull(agha = Agha.get(mission.getType()))) {
            Ut.contract((Object)agha, Vertx.class, (Object)this.vertx);
            if (Debugger.onJobBooting()) {
                LOGGER.info("[ Job ] Agha = {0} has been selected for job {1} of type {2}", new Object[]{agha.getClass(), mission.getCode(), mission.getType()});
            }
            if (JobType.ONCE != mission.getType()) {
                agha.begin(mission);
            }
        }
        return Ux.future();
    }
}

