/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.optic.business;

import cn.vertxup.ambient.domain.tables.daos.XCategoryDao;
import cn.vertxup.ambient.domain.tables.daos.XTabularDao;
import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ambient.refine.At;
import io.vertx.tp.optic.component.Dictionary;
import io.vertx.tp.optic.component.DictionaryPlugin;
import io.vertx.up.commune.config.DictSource;
import io.vertx.up.eon.em.SourceType;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ExAmbientDictionary
implements Dictionary {
    public Future<ConcurrentMap<String, JsonArray>> fetchAsync(MultiMap paramMap, List<DictSource> sources) {
        if (Objects.isNull(sources) || sources.isEmpty()) {
            return Ux.future(new ConcurrentHashMap());
        }
        ArrayList futures = new ArrayList();
        sources.forEach(source -> futures.add(this.fetchSource((DictSource)source, paramMap)));
        return Ux.thenCompress(futures).compose(dict -> {
            StringBuilder report = new StringBuilder();
            report.append("[ PT ] Dictionary Total\uff1a").append(dict.size());
            dict.forEach((key, array) -> report.append("\n\tkey = ").append((String)key).append(", value size = ").append(array.size()));
            At.infoFlow(this.getClass(), report.toString(), new Object[0]);
            return Ux.future((Object)dict);
        });
    }

    private Future<ConcurrentMap<String, JsonArray>> fetchSource(DictSource source, MultiMap paramMap) {
        SourceType type = source.getSourceType();
        if (SourceType.TABULAR == type) {
            return this.fetchTabular(source, paramMap);
        }
        if (SourceType.CATEGORY == type) {
            return this.fetchCategory(source, paramMap);
        }
        return this.fetchAssist(source, paramMap);
    }

    private Future<ConcurrentMap<String, JsonArray>> fetchTabular(DictSource source, MultiMap paramMap) {
        String sigma = paramMap.get("sigma");
        return Ux.Jooq.on(XTabularDao.class).fetchAndAsync(this.toFilters(source, sigma)).compose(Ux::fnJMapType);
    }

    private Future<ConcurrentMap<String, JsonArray>> fetchCategory(DictSource source, MultiMap paramMap) {
        String sigma = paramMap.get("sigma");
        return Ux.Jooq.on(XCategoryDao.class).fetchAndAsync(this.toFilters(source, sigma)).compose(Ux::fnJMapType);
    }

    private Future<ConcurrentMap<String, JsonArray>> fetchAssist(DictSource source, MultiMap paramMap) {
        ConcurrentHashMap uniqueMap = new ConcurrentHashMap();
        DictionaryPlugin plugin = (DictionaryPlugin)source.getPlugin();
        if (Objects.isNull(plugin) || Ut.isNil((String)source.getKey())) {
            return Ux.future(uniqueMap);
        }
        plugin.configuration(source.getPluginConfig());
        return plugin.fetchAsync(source, paramMap).compose(result -> {
            uniqueMap.put(source.getKey(), result);
            return Ux.future((Object)uniqueMap);
        });
    }

    private JsonObject toFilters(DictSource source, String sigma) {
        JsonObject filters = new JsonObject();
        filters.put("sigma", sigma);
        Set typeSet = source.getTypes();
        if (!typeSet.isEmpty()) {
            filters.put("type,i", Ut.toJArray((Set)typeSet));
            filters.put("", Boolean.TRUE);
        }
        return filters;
    }
}

