/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.ambient.service;

import cn.vertxup.ambient.domain.tables.daos.XCategoryDao;
import cn.vertxup.ambient.domain.tables.daos.XNumberDao;
import cn.vertxup.ambient.domain.tables.daos.XTabularDao;
import cn.vertxup.ambient.service.DatumStub;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ambient.refine.At;
import io.vertx.tp.ke.refine.Ke;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Objects;

public class DatumService
implements DatumStub {
    @Override
    public Future<JsonArray> tabulars(String appId, String type) {
        return this.fetchArray(XTabularDao.class, At.filters(appId, type, null));
    }

    @Override
    public Future<JsonArray> tabularsBySigma(String sigma, JsonArray types) {
        return this.fetchArray(XTabularDao.class, At.filtersSigma(sigma, types, null));
    }

    @Override
    public Future<JsonArray> categories(String appId, String type) {
        return this.fetchArray(XCategoryDao.class, At.filters(appId, type, null));
    }

    @Override
    public Future<JsonArray> categories(String appId, JsonArray types) {
        return this.fetchArray(XCategoryDao.class, At.filters(appId, types, null));
    }

    @Override
    public Future<JsonArray> categoriesBySigma(String sigma, String type) {
        return this.fetchArray(XCategoryDao.class, At.filtersSigma(sigma, type, null));
    }

    @Override
    public Future<JsonArray> categoriesBySigma(String sigma, JsonArray types) {
        return this.fetchArray(XCategoryDao.class, At.filtersSigma(sigma, types, null));
    }

    @Override
    public Future<JsonObject> tabular(String appId, String type, String code) {
        return Ux.Jooq.on(XTabularDao.class).fetchOneAsync(At.filters(appId, type, code)).compose(Ux::futureJ);
    }

    @Override
    public Future<JsonObject> category(String appId, String type, String code) {
        return Ux.Jooq.on(XCategoryDao.class).fetchOneAsync(At.filters(appId, type, code)).compose(Ux::futureJ);
    }

    @Override
    public Future<JsonArray> tabulars(String appId, JsonArray types) {
        return this.fetchArray(XTabularDao.class, At.filters(appId, types, null));
    }

    @Override
    public Future<JsonArray> numbers(String appId, String code, Integer count) {
        At.infoFlow(this.getClass(), "Number parameters: appId = {0}, code = {1}, count = {2}", appId, code, count);
        JsonObject filters = new JsonObject();
        filters.put("appId", appId);
        filters.put("code", code);
        return this.numbers(filters, count);
    }

    @Override
    public Future<JsonArray> numbersBySigma(String sigma, String code, Integer count) {
        At.infoFlow(this.getClass(), "Number parameters: sigma = {0}, code = {1}, count = {2}", sigma, code, count);
        JsonObject filters = new JsonObject();
        filters.put("sigma", sigma);
        filters.put("code", code);
        return this.numbers(filters, count);
    }

    @Override
    public Future<JsonArray> codesBySigma(String sigma, String identifier, Integer count) {
        At.infoFlow(this.getClass(), "Number parameters: sigma = {0}, identifier = {1}, count = {2}", sigma, identifier, count);
        JsonObject filters = new JsonObject();
        filters.put("sigma", sigma);
        filters.put("identifier", identifier);
        return this.numbers(filters, count);
    }

    private Future<JsonArray> numbers(JsonObject filters, Integer count) {
        return Ux.Jooq.on(XNumberDao.class).fetchOneAsync(filters).compose(number -> {
            if (Objects.isNull(number)) {
                return Ux.future((Object)new JsonArray());
            }
            return At.serialsAsync(number, count).compose(generation -> Ux.Jooq.on(XNumberDao.class).updateAsync((Object)number.setCurrent(number.getCurrent() + (long)count.intValue())).compose(updated -> Ux.future((Object)new JsonArray(generation)))).otherwise(Ux.otherwise(JsonArray::new));
        });
    }

    private Future<JsonArray> fetchArray(Class<?> daoCls, JsonObject filters) {
        return Ux.Jooq.on(daoCls).fetchAndAsync(filters).compose(Ux::futureA).compose(array -> {
            Ut.itJArray((JsonArray)array).forEach(json -> Ke.mount((JsonObject)json, (String)"metadata"));
            return Ux.future((Object)array);
        });
    }
}

