/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.ambient.service;

import cn.vertxup.ambient.domain.tables.daos.XTodoDao;
import cn.vertxup.ambient.domain.tables.pojos.XTodo;
import cn.vertxup.ambient.service.TodoStub;
import com.fasterxml.jackson.core.type.TypeReference;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ambient.cv.em.TodoStatus;
import io.vertx.tp.ambient.init.AtPin;
import io.vertx.tp.ambient.refine.At;
import io.vertx.tp.ke.refine.Ke;
import io.vertx.tp.optic.business.ExTodo;
import io.vertx.up.log.Annal;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class TodoService
implements TodoStub {
    private static final Annal LOGGER = Annal.get(TodoService.class);

    @Override
    public Future<JsonObject> createTodo(String type, JsonObject data) {
        JsonObject defaultTodo = AtPin.getTodo(type);
        JsonObject inputData = data.copy();
        if (Objects.nonNull(defaultTodo)) {
            JsonObject params = data.copy();
            String name = Ut.fromExpression((String)defaultTodo.getString("name"), (JsonObject)params);
            String code = Ut.fromExpression((String)defaultTodo.getString("code"), (JsonObject)params);
            String url = Ut.fromExpression((String)defaultTodo.getString("todoUrl"), (JsonObject)params);
            inputData.mergeIn(defaultTodo);
            inputData.put("name", name);
            inputData.put("code", code);
            inputData.put("todoUrl", url);
        }
        XTodo todo = (XTodo)Ut.deserialize((JsonObject)inputData, XTodo.class);
        return Ux.Jooq.on(XTodoDao.class).insertAsync((Object)todo).compose(Ux::futureJ);
    }

    @Override
    public Future<JsonArray> fetchTodos(String sigma, String type, JsonArray statues) {
        JsonObject filters = new JsonObject();
        filters.put("sigma", sigma);
        if (Objects.nonNull(type)) {
            filters.put("type", type);
        }
        filters.put("status,i", statues);
        return Ux.Jooq.on(XTodoDao.class).fetchAndAsync(filters).compose(Ux::futureA);
    }

    @Override
    public Future<JsonArray> fetchTodos(String sigma, JsonArray types, JsonArray statues) {
        JsonObject filters = this.toFilters(sigma, types, statues);
        return Ux.Jooq.on(XTodoDao.class).fetchAndAsync(filters).compose(Ux::futureA);
    }

    @Override
    public Future<JsonArray> fetchTodos(String sigma, JsonArray types, JsonArray statues, JsonArray codes) {
        JsonObject filters = this.toFilters(sigma, types, statues);
        filters.put("code,i", codes);
        return Ux.Jooq.on(XTodoDao.class).fetchAndAsync(filters).compose(Ux::futureA);
    }

    private JsonObject toFilters(String sigma, JsonArray types, JsonArray statues) {
        JsonObject filters = new JsonObject();
        filters.put("sigma", sigma);
        if (Objects.nonNull(types)) {
            filters.put("type,i", types);
        }
        filters.put("status,i", statues);
        return filters;
    }

    @Override
    public Future<JsonArray> updateStatus(Set<String> keys, JsonObject params) {
        return Ux.Jooq.on(XTodoDao.class).fetchInAsync("key", Ut.toJArray(keys)).compose(Ux::futureA).compose(Ut.ifNil(JsonArray::new, todoArray -> {
            List todoList = Ut.deserialize((JsonArray)todoArray, (TypeReference)new TypeReference<List<XTodo>>(){});
            todoList = todoList.stream().map(todo -> this.combineTodo((XTodo)todo, params)).collect(Collectors.toList());
            return Ux.Jooq.on(XTodoDao.class).updateAsync(todoList).compose(Ux::futureA);
        }));
    }

    @Override
    public Future<JsonObject> updateStatus(String key, JsonObject params) {
        return Ux.Jooq.on(XTodoDao.class).fetchByIdAsync((Object)key).compose(Ux::futureJ).compose(Ut.ifJNil(todoJson -> {
            XTodo todo = (XTodo)Ut.deserialize((JsonObject)todoJson, XTodo.class);
            todo = this.combineTodo(todo, params);
            return Ux.Jooq.on(XTodoDao.class).updateAsync((Object)todo).compose(Ux::futureJ);
        }));
    }

    private XTodo combineTodo(XTodo todo, JsonObject params) {
        if (Objects.isNull(todo)) {
            return null;
        }
        String userId = params.getString("userId");
        if (Ut.notNil((String)userId)) {
            todo.setUpdatedBy(userId);
            todo.setUpdatedAt(LocalDateTime.now());
            if (Objects.isNull(todo.getCreatedBy())) {
                todo.setCreatedBy(userId);
            }
        }
        if (params.containsKey("status")) {
            String status = params.getString("status");
            todo.setStatus(status);
            if (TodoStatus.FINISHED.name().equals(status)) {
                todo.setFinishedBy(todo.getUpdatedBy());
            }
        }
        return todo;
    }

    @Override
    public Future<JsonObject> fetchTodo(String key) {
        return Ux.Jooq.on(XTodoDao.class).fetchByIdAsync((Object)key).compose(Ux::futureJ).compose(Ut.ifNil(JsonObject::new, todo -> Ke.channel(ExTodo.class, () -> todo, channel -> {
            At.infoInit(LOGGER, "Todo channel selected: {0}", channel.getClass().getName());
            JsonObject params = Ut.elementSubset((JsonObject)todo, (String[])new String[]{"modelId", "modelCategory", "modelKey", "sigma"});
            return channel.fetchAsync(key, params).compose(Ut.ifMerge((JsonObject)todo));
        })));
    }
}

