/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.ambient.refine;

import cn.vertxup.ambient.domain.tables.daos.XSourceDao;
import cn.vertxup.ambient.domain.tables.pojos.XApp;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.FileUpload;
import io.vertx.tp.ambient.atom.AtApp;
import io.vertx.tp.ambient.atom.AtConfig;
import io.vertx.tp.ambient.init.AtPin;
import io.vertx.tp.ambient.refine.AtLog;
import io.vertx.tp.ke.refine.Ke;
import io.vertx.up.commune.config.Database;
import io.vertx.up.log.Annal;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.text.MessageFormat;
import java.util.UUID;
import org.jooq.DSLContext;

class AtEnv {
    private static final Annal LOGGER = Annal.get(AtEnv.class);

    AtEnv() {
    }

    static XApp getApp(DSLContext context, String name) {
        return AtApp.create(context, name).getApp();
    }

    static XApp getApp(String name) {
        return AtApp.create(name).getApp();
    }

    static Future<Database> getDatabaseWithCache(String appId) {
        return Ke.poolAsync((String)"POOL_DATABASE", (String)appId, () -> AtEnv.getDatabase(appId));
    }

    static JsonObject upload(String category, FileUpload fileUpload) {
        JsonObject uploaded = new JsonObject();
        String originalFile = fileUpload.fileName();
        if (Ut.notNil((String)originalFile) && originalFile.contains(".")) {
            AtConfig config = AtPin.getConfig();
            int lastIndex = originalFile.lastIndexOf(46);
            String fileName = originalFile.substring(0, lastIndex);
            String extension = originalFile.substring(lastIndex + 1);
            String key = UUID.randomUUID().toString();
            String downloadUrl = MessageFormat.format("/api/file/download/{0}", key);
            uploaded.put("key", key).put("storeWay", config.getFileStorage()).put("status", "PROGRESS").put("name", originalFile).put("fileKey", Ut.randomString((int)64)).put("fileName", fileName).put("fileUrl", downloadUrl).put("filePath", fileUpload.uploadedFileName()).put("extension", extension).put("module", category).put("mime", fileUpload.contentType()).put("size", Long.valueOf(fileUpload.size())).put("language", config.getFileLanguage()).put("metadata", new JsonObject().encode());
        }
        return uploaded;
    }

    private static Future<Database> fromJsonAsync(JsonObject source) {
        Database database = new Database();
        database.fromJson(source);
        return Ux.future((Object)database);
    }

    private static Future<Database> getDatabase(String appId) {
        AtLog.infoEnv(LOGGER, "Get data source from appId = {0}", appId);
        return Ux.Jooq.on(XSourceDao.class).fetchOneAsync("appId", (Object)appId).compose(Ux::futureJ).compose(AtEnv::fromJsonAsync);
    }
}

