/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.optic.business;

import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.json.JsonArray;
import io.vertx.tp.ambient.refine.At;
import io.vertx.tp.ambient.uca.dict.Dpm;
import io.vertx.tp.optic.component.Dictionary;
import io.vertx.up.commune.exchange.DictSource;
import io.vertx.up.eon.em.GlossaryType;
import io.vertx.up.unity.Ux;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ExAmbientDictionary
implements Dictionary {
    public Future<ConcurrentMap<String, JsonArray>> fetchAsync(MultiMap paramMap, List<DictSource> sources) {
        if (Objects.isNull(sources) || sources.isEmpty()) {
            return Ux.future(new ConcurrentHashMap());
        }
        ArrayList futures = new ArrayList();
        sources.forEach(source -> {
            GlossaryType type = source.getSourceType();
            Dpm dpm = Dpm.get(type);
            if (Objects.nonNull(dpm)) {
                futures.add(dpm.fetchAsync((DictSource)source, paramMap));
            }
        });
        return Ux.thenCompress(futures).compose(dict -> {
            StringBuilder report = new StringBuilder();
            report.append("[ PT ] Dictionary Total\uff1a").append(dict.size());
            dict.forEach((key, array) -> report.append("\n\tkey = ").append((String)key).append(", value size = ").append(array.size()));
            At.infoFlow(this.getClass(), report.toString(), new Object[0]);
            return Ux.future((Object)dict);
        });
    }
}

