/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.ambient.service;

import cn.vertxup.ambient.domain.tables.daos.XAppDao;
import cn.vertxup.ambient.service.AppStub;
import cn.vertxup.ambient.service.InitStub;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ambient.init.AtPin;
import io.vertx.tp.ambient.refine.At;
import io.vertx.tp.ke.refine.Ke;
import io.vertx.tp.optic.extension.Init;
import io.vertx.tp.optic.extension.Prerequisite;
import io.vertx.up.atom.unity.Uson;
import io.vertx.up.log.Annal;
import io.vertx.up.unity.Ux;
import java.util.Objects;
import javax.inject.Inject;

public class InitService
implements InitStub {
    private static final Annal LOGGER = Annal.get(InitService.class);
    @Inject
    private transient AppStub stub;

    @Override
    public Future<JsonObject> initCreation(String appId, JsonObject data) {
        return Ux.future((Object)data.put("key", appId)).compose(At.initApp().apply()).compose(At.initSource().apply()).compose(At.initDatabase().apply()).compose(this::initDefined).compose(At.initData().apply()).compose(Ke.image((String)"logo"));
    }

    @Override
    public Future<JsonObject> initEdition(String appName) {
        return this.initModeling(appName).compose(At.initData().apply());
    }

    @Override
    public Future<JsonObject> prerequisite(String appName) {
        Prerequisite prerequisite = AtPin.getPrerequisite();
        if (Objects.isNull(prerequisite)) {
            At.infoInit(LOGGER, "`Prerequisite` configuration is null", new Object[0]);
            return Ux.future((Object)new JsonObject());
        }
        return prerequisite.prepare(appName);
    }

    @Override
    public Future<JsonObject> initModeling(String appName) {
        return Ux.Jooq.on(XAppDao.class).fetchOneAsync("name", (Object)appName).compose(Ux::futureJ).compose(this::initCombine).compose(this::initDefined).compose(Ke.image((String)"logo"));
    }

    private Future<JsonObject> initCombine(JsonObject appJson) {
        return this.stub.fetchSource(appJson.getString("key")).compose(source -> Uson.create((JsonObject)appJson).append("source", source).toFuture());
    }

    private Future<JsonObject> initDefined(JsonObject input) {
        Init initializer = AtPin.getInit();
        if (Objects.isNull(initializer)) {
            At.infoInit(LOGGER, "`Init` configuration is null", new Object[0]);
            return Ux.future((Object)input);
        }
        return (Future)initializer.apply().apply(input);
    }
}

