/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.optic.business;

import io.vertx.core.MultiMap;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ambient.uca.dict.Dpm;
import io.vertx.up.commune.exchange.DictEpsilon;
import io.vertx.up.commune.exchange.DictSource;
import io.vertx.up.eon.em.GlossaryType;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class ExAttributeComponent {
    public ConcurrentMap<String, JsonArray> source(JsonObject definition) {
        DictSource sourceDict;
        GlossaryType type;
        Dpm dpm;
        JsonObject sourceDictJson = definition.getJsonObject("sourceDict");
        ConcurrentHashMap<String, JsonArray> sourceData = new ConcurrentHashMap<String, JsonArray>();
        if (Ut.notNil((JsonObject)sourceDictJson) && Objects.nonNull(dpm = Dpm.get(type = (sourceDict = new DictSource(sourceDictJson)).getSourceType()))) {
            MultiMap paramMap = MultiMap.caseInsensitiveMultiMap();
            JsonObject sourceParams = definition.getJsonObject("sourceParams");
            if (Ut.notNil((JsonObject)sourceParams)) {
                sourceParams.stream().filter(Objects::nonNull).filter(entry -> Objects.nonNull(entry.getValue())).forEach(entry -> paramMap.add((String)entry.getKey(), entry.getValue().toString()));
            }
            sourceData.putAll(dpm.fetch(sourceDict, paramMap));
        }
        return sourceData;
    }

    protected Object translateTo(Object value, JsonObject definition) {
        if (Objects.isNull(value)) {
            return null;
        }
        JsonObject data = this.translateData(definition, false);
        Object processed = data.getValue(value.toString(), value);
        return this.normalizeValue(processed, definition);
    }

    protected Object translateFrom(Object value, JsonObject definition) {
        if (Objects.isNull(value)) {
            return null;
        }
        JsonObject data = this.translateData(definition, true);
        Object processed = data.getValue(value.toString(), value);
        return this.normalizeValue(processed, definition);
    }

    private JsonObject translateData(JsonObject definition, boolean isFrom) {
        JsonObject consumer = definition.getJsonObject("sourceConsumer");
        DictEpsilon epsilon = new DictEpsilon();
        epsilon.fromJson(consumer);
        JsonObject dictData = Ut.sureJObject((JsonObject)definition.getJsonObject("sourceData"));
        String key = epsilon.getSource();
        JsonArray data = Ut.notNil((String)key) ? dictData.getJsonArray(key) : new JsonArray();
        JsonObject result = new JsonObject();
        if (epsilon.isValid()) {
            Ut.itJArray((JsonArray)data).forEach(item -> {
                String inValue = item.getString(epsilon.getIn());
                String outValue = item.getString(epsilon.getOut());
                if (Ut.notNil((String)inValue) && Ut.notNil((String)outValue)) {
                    if (isFrom) {
                        result.put(inValue, outValue);
                    } else {
                        result.put(outValue, inValue);
                    }
                }
            });
        }
        return result;
    }

    private Object normalizeValue(Object value, JsonObject definition) {
        if (Objects.isNull(value)) {
            return null;
        }
        if (definition.containsKey("sourceNorm")) {
            JsonObject normData = Ut.sureJObject((JsonObject)definition.getJsonObject("sourceNorm"));
            return normData.getValue(value.toString(), value);
        }
        return value;
    }
}

