/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.optic.extension;

import cn.vertxup.ambient.domain.tables.daos.XAppDao;
import cn.vertxup.ambient.domain.tables.pojos.XApp;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ambient.refine.At;
import io.vertx.tp.optic.extension.Init;
import io.vertx.up.log.Annal;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.function.Function;

public class AppInit
implements Init {
    private static final Annal LOGGER = Annal.get(AppInit.class);

    public Function<JsonObject, Future<JsonObject>> apply() {
        return appJson -> {
            At.infoApp(LOGGER, "XApp initializing with: {0}", appJson.encode());
            XApp app = this.init((JsonObject)appJson);
            return Ux.Jooq.on(XAppDao.class).upsertAsync(this.whereUnique((JsonObject)appJson), (Object)app).compose(Ux::futureJ).compose(input -> Ux.future((Object)this.result((JsonObject)input, (JsonObject)appJson)));
        };
    }

    public JsonObject result(JsonObject input, JsonObject appJson) {
        JsonObject result = new JsonObject();
        if (!Ut.isNil((JsonObject)appJson)) {
            result.mergeIn(appJson);
        }
        if (!Ut.isNil((JsonObject)input)) {
            result.put("source", input.getValue("source"));
        }
        return result;
    }

    public JsonObject whereUnique(JsonObject input) {
        JsonObject filters = new JsonObject();
        filters.put("key", input.getValue("key"));
        return filters;
    }

    private XApp init(JsonObject input) {
        JsonArray files;
        if (!input.containsKey("appKey")) {
            input.put("appKey", Ut.randomString((int)64));
        }
        if (null != (files = input.getJsonArray("logo"))) {
            input.put("logo", files.encode());
        }
        XApp app = (XApp)Ut.deserialize((JsonObject)input.copy(), XApp.class);
        app.setActive(Boolean.TRUE);
        return app;
    }
}

