/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.ambient.service;

import cn.vertxup.ambient.domain.tables.daos.XActivityChangeDao;
import cn.vertxup.ambient.domain.tables.daos.XActivityDao;
import cn.vertxup.ambient.domain.tables.pojos.XActivity;
import cn.vertxup.ambient.domain.tables.pojos.XActivityChange;
import cn.vertxup.ambient.service.ActivityStub;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ambient.cv.em.ActivityStatus;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class ActivityService
implements ActivityStub {
    @Override
    public Future<JsonArray> fetchActivities(String identifier, String key) {
        JsonObject filters = new JsonObject();
        filters.put("modelId", (Object)identifier);
        filters.put("modelKey", (Object)key);
        filters.put("active", (Object)Boolean.TRUE);
        return Ux.Jooq.on(XActivityDao.class).fetchAndAsync(filters).compose(Ux::futureA).compose(Ut.ifJArray((String[])new String[]{"recordNew", "recordOld"}));
    }

    @Override
    public Future<JsonArray> fetchActivities(String identifier, String key, String field) {
        JsonObject filters = new JsonObject();
        filters.put("modelId", (Object)identifier);
        filters.put("modelKey", (Object)key);
        filters.put("active", (Object)Boolean.TRUE);
        return Ux.Jooq.on(XActivityDao.class).fetchAndAsync(filters).compose(activities -> {
            Set activityIds = activities.stream().map(XActivity::getKey).collect(Collectors.toSet());
            JsonObject criteria = new JsonObject();
            criteria.put("activityId,i", (Object)Ut.toJArray(activityIds));
            criteria.put("fieldName", (Object)field);
            return Ux.Jooq.on(XActivityChangeDao.class).fetchAndAsync(criteria).compose(Ux::futureA);
        });
    }

    @Override
    public Future<JsonArray> fetchChanges(String activityId) {
        return this.fetchChangeList(activityId).compose(Ux::futureA);
    }

    @Override
    public Future<JsonObject> fetchActivity(String id) {
        return Ux.Jooq.on(XActivityDao.class).fetchByIdAsync((Object)id).compose(Ut.ifNil(JsonObject::new, activity -> this.fetchChanges(activity.getKey()).compose(changes -> {
            JsonObject activityJson = Ux.toJson((Object)activity);
            Ut.ifJObject((JsonObject)activityJson, (String[])new String[]{"recordNew", "recordOld"});
            activityJson.put("changes", changes);
            return Ux.future((Object)activityJson);
        })));
    }

    private Future<List<XActivityChange>> fetchChangeList(String activityId) {
        return Ux.Jooq.on(XActivityChangeDao.class).fetchAsync("activityId", (Object)activityId);
    }

    @Override
    public Future<JsonArray> saveChanges(String id, ActivityStatus status) {
        return this.fetchChangeList(id).compose(changes -> {
            ArrayList original = new ArrayList(changes);
            Ut.itList(original, (change, index) -> {
                String oldStatus = change.getStatus();
                XActivityChange itemRef = (XActivityChange)changes.get((int)index);
                if (Ut.isNil((String)oldStatus)) {
                    itemRef.setStatus(status.name());
                } else if (ActivityStatus.CONFIRMED == status) {
                    ActivityStatus old = (ActivityStatus)Ut.toEnum(change::getStatus, ActivityStatus.class, (Enum)ActivityStatus.SYSTEM);
                    if (ActivityStatus.PENDING == old) {
                        itemRef.setStatus(ActivityStatus.CONFIRMED.name());
                    }
                } else {
                    itemRef.setStatus(status.name());
                }
            });
            return Ux.Jooq.on(XActivityChangeDao.class).updateAsync(changes).compose(Ux::futureA);
        });
    }
}

