/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.ambient.refine;

import cn.vertxup.ambient.domain.tables.pojos.XNumber;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.FileUpload;
import io.vertx.tp.ambient.refine.AtEnv;
import io.vertx.tp.ambient.refine.AtLog;
import io.vertx.tp.ambient.refine.AtQuery;
import io.vertx.tp.ambient.refine.AtSerial;
import io.vertx.tp.ambient.refine.Pool;
import io.vertx.tp.optic.extension.AppInit;
import io.vertx.tp.optic.extension.DatabaseInit;
import io.vertx.tp.optic.extension.DatumInit;
import io.vertx.tp.optic.extension.Init;
import io.vertx.tp.optic.extension.SourceInit;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.unity.Ux;
import java.util.List;

public class At {
    public static void infoInit(Annal logger, String pattern, Object ... args) {
        AtLog.info(logger, "Init", pattern, args);
    }

    public static void infoFile(Annal logger, String pattern, Object ... args) {
        AtLog.info(logger, "File", pattern, args);
    }

    public static void infoApp(Annal logger, String pattern, Object ... args) {
        AtLog.info(logger, "Application", pattern, args);
    }

    public static void infoFlow(Class<?> clazz, String pattern, Object ... args) {
        Annal logger = Annal.get(clazz);
        AtLog.info(logger, "Execution", pattern, args);
    }

    public static Init initApp() {
        return (Init)Fn.pool(Pool.INIT_POOL, (Object)AppInit.class.getName(), AppInit::new);
    }

    public static Init initSource() {
        return (Init)Fn.pool(Pool.INIT_POOL, (Object)SourceInit.class.getName(), SourceInit::new);
    }

    public static Init initDatabase() {
        return (Init)Fn.pool(Pool.INIT_POOL, (Object)DatabaseInit.class.getName(), DatabaseInit::new);
    }

    public static Init initData() {
        return (Init)Fn.pool(Pool.INIT_POOL, (Object)DatumInit.class.getName(), DatumInit::new);
    }

    public static List<String> serials(XNumber number, Integer count) {
        return AtSerial.serials(number, count);
    }

    public static Future<List<String>> serialsAsync(XNumber number, Integer count) {
        return Ux.future(AtSerial.serials(number, count));
    }

    public static JsonObject upload(String category, FileUpload fileUpload) {
        return AtEnv.upload(category, fileUpload);
    }

    public static JsonObject filters(String appId, String type, String code) {
        return AtQuery.filters(appId, new JsonArray().add((Object)type), code);
    }

    public static JsonObject filters(String appId, JsonArray types, String code) {
        return AtQuery.filters(appId, types, code);
    }

    public static JsonObject filtersSigma(String sigma, String type, String code) {
        return AtQuery.filtersSigma(sigma, new JsonArray().add((Object)type), code);
    }

    public static JsonObject filtersSigma(String sigma, JsonArray types, String code) {
        return AtQuery.filtersSigma(sigma, types, code);
    }
}

