/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.ambient.uca.dict;

import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.json.JsonArray;
import io.vertx.tp.ambient.uca.dict.Dpm;
import io.vertx.tp.ambient.uca.dict.DpmTool;
import io.vertx.tp.optic.component.DictionaryPlugin;
import io.vertx.up.commune.exchange.DiSource;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class DpmAssist
implements Dpm {
    @Override
    public Future<ConcurrentMap<String, JsonArray>> fetchAsync(DiSource source, MultiMap params) {
        ConcurrentHashMap uniqueMap = new ConcurrentHashMap();
        DictionaryPlugin plugin = (DictionaryPlugin)source.getPlugin();
        if (Objects.isNull(plugin) || Ut.isNil((String)source.getKey())) {
            return Ux.future(uniqueMap);
        }
        return DpmTool.cachedBy(source.getKey(), () -> {
            plugin.configuration(source.getPluginConfig());
            return plugin.fetchAsync(source, params);
        }).compose(result -> {
            uniqueMap.put(source.getKey(), result);
            return Ux.future((Object)uniqueMap);
        });
    }

    @Override
    public ConcurrentMap<String, JsonArray> fetch(DiSource source, MultiMap params) {
        ConcurrentHashMap<String, JsonArray> uniqueMap = new ConcurrentHashMap<String, JsonArray>();
        DictionaryPlugin plugin = (DictionaryPlugin)source.getPlugin();
        if (Objects.isNull(plugin) || Ut.isNil((String)source.getKey())) {
            return uniqueMap;
        }
        plugin.configuration(source.getPluginConfig());
        JsonArray result = plugin.fetch(source, params);
        uniqueMap.put(source.getKey(), result);
        return uniqueMap;
    }
}

