/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.ambient.uca.dict;

import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ambient.uca.dict.Dpm;
import io.vertx.tp.ambient.uca.dict.DpmAssist;
import io.vertx.tp.ambient.uca.dict.DpmCategory;
import io.vertx.tp.ambient.uca.dict.DpmTabular;
import io.vertx.up.atom.Kv;
import io.vertx.up.eon.em.GlossaryType;
import io.vertx.up.unity.Ux;
import io.vertx.up.unity.UxPool;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.function.Supplier;

class DpmTool {
    static final ConcurrentMap<GlossaryType, Dpm> POOL_DPM = new ConcurrentHashMap<GlossaryType, Dpm>(){
        {
            this.put(GlossaryType.ASSIST, (Dpm)Ut.instance(DpmAssist.class, (Object[])new Object[0]));
            this.put(GlossaryType.CATEGORY, (Dpm)Ut.instance(DpmCategory.class, (Object[])new Object[0]));
            this.put(GlossaryType.TABULAR, (Dpm)Ut.instance(DpmTabular.class, (Object[])new Object[0]));
        }
    };

    DpmTool() {
    }

    static JsonObject condition(MultiMap params, Set<String> typeSet) {
        JsonObject condition = new JsonObject();
        String sigma = params.get("sigma");
        condition.put("sigma", (Object)sigma);
        if (!typeSet.isEmpty()) {
            condition.put("type,i", (Object)Ut.toJArray(typeSet));
            condition.put("", (Object)Boolean.TRUE);
        }
        return condition;
    }

    static Future<JsonArray> cachedBy(String key, Supplier<Future<JsonArray>> executor) {
        UxPool pool = Ux.Pool.on((String)"zero.pool.directory");
        return pool.get((Object)key).compose(queried -> {
            if (Objects.isNull(queried)) {
                return ((Future)executor.get()).compose(actual -> pool.put((Object)key, actual, 300)).compose(Kv::value);
            }
            return Ux.future((Object)queried);
        });
    }

    static Future<ConcurrentMap<String, JsonArray>> cachedDict(Set<String> typeSet, Function<Set<String>, Future<ConcurrentMap<String, JsonArray>>> executor) {
        UxPool pool = Ux.Pool.on((String)"zero.pool.directory");
        return pool.get(typeSet).compose(cachedMap -> {
            Set newSet = Ut.diff((Set)typeSet, cachedMap.keySet());
            ConcurrentHashMap processed = new ConcurrentHashMap(cachedMap);
            if (newSet.isEmpty()) {
                return Ux.future(processed);
            }
            return ((Future)executor.apply(newSet)).compose(queried -> {
                ConcurrentHashMap futureMap = new ConcurrentHashMap();
                queried.forEach((key, data) -> futureMap.put(key, pool.put(key, data, 300).compose(Kv::value)));
                return Ux.thenCombine(futureMap);
            }).compose(newAdded -> {
                processed.putAll(newAdded);
                return Ux.future((Object)processed);
            });
        });
    }
}

