/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.optic.environment;

import cn.vertxup.ambient.domain.tables.daos.XAppDao;
import cn.vertxup.ambient.domain.tables.daos.XSourceDao;
import cn.vertxup.ambient.domain.tables.pojos.XApp;
import cn.vertxup.ambient.domain.tables.pojos.XSource;
import io.vertx.tp.ambient.refine.At;
import io.vertx.tp.plugin.database.DataPool;
import io.vertx.up.commune.config.Database;
import io.vertx.up.log.Annal;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

class UnityAsker {
    private static final Annal LOGGER = Annal.get(UnityAsker.class);
    private static final ConcurrentMap<String, XApp> APP_POOL = new ConcurrentHashMap<String, XApp>();
    private static final ConcurrentMap<String, XSource> SOURCE_POOL = new ConcurrentHashMap<String, XSource>();

    UnityAsker() {
    }

    static void init() {
        DataPool pool = UnityAsker.getPool();
        List applications = Ux.Jooq.on(XAppDao.class, (DataPool)pool).fetchAll();
        At.infoApp(LOGGER, "{0} Application have been initialized successfully!", applications.size());
        List sources = Ux.Jooq.on(XSourceDao.class, (DataPool)pool).fetchAll();
        At.infoApp(LOGGER, "{0} Data source have been initialized successfully!", sources.size());
        APP_POOL.putAll(Ut.elementZip((Collection)applications, XApp::getKey, app -> app));
        SOURCE_POOL.putAll(Ut.elementZip((Collection)sources, XSource::getAppId, source -> source));
    }

    private static DataPool getPool() {
        Database database = Database.getCurrent();
        return DataPool.create((Database)database);
    }

    static ConcurrentMap<String, XApp> getApps() {
        return APP_POOL;
    }

    static ConcurrentMap<String, XSource> getSources() {
        return SOURCE_POOL;
    }
}

