/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.optic.extension;

import cn.vertxup.ambient.domain.tables.daos.XSourceDao;
import cn.vertxup.ambient.domain.tables.pojos.XSource;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ambient.refine.At;
import io.vertx.tp.optic.extension.Init;
import io.vertx.up.log.Annal;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;

public class SourceInit
implements Init {
    private static final Annal LOGGER = Annal.get(SourceInit.class);

    public Function<JsonObject, Future<JsonObject>> apply() {
        return appJson -> {
            At.infoApp(LOGGER, "XSource initializing with: {0}", appJson.encode());
            JsonObject sourceJson = appJson.getJsonObject("source");
            XSource source = this.init(sourceJson, (JsonObject)appJson);
            return Ux.Jooq.on(XSourceDao.class).upsertAsync(this.whereUnique((JsonObject)appJson), (Object)source).compose(Ux::futureJ).compose(updated -> Ux.future((Object)this.result((JsonObject)appJson, (JsonObject)updated)));
        };
    }

    public JsonObject whereUnique(JsonObject appJson) {
        JsonObject filters = new JsonObject();
        filters.put("appId", appJson.getValue("key"));
        return filters;
    }

    public JsonObject result(JsonObject input, JsonObject sourceJson) {
        input.put("source", (Object)sourceJson);
        return input;
    }

    private XSource init(JsonObject input, JsonObject appJson) {
        XSource source = (XSource)Ut.deserialize((JsonObject)input.copy(), XSource.class);
        source.setActive(Boolean.TRUE);
        source.setAppId(appJson.getString("key"));
        source.setJdbcConfig(new JsonObject().encode());
        source.setMetadata(new JsonObject().encode());
        source.setLanguage(appJson.getString("language"));
        if (Objects.isNull(source.getKey())) {
            source.setKey(UUID.randomUUID().toString());
        }
        return source;
    }
}

