/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.ambient.api.file;

import cn.vertxup.ambient.domain.tables.daos.XAttachmentDao;
import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ambient.refine.At;
import io.vertx.up.annotations.Address;
import io.vertx.up.annotations.Queue;
import io.vertx.up.commune.Envelop;
import io.vertx.up.log.Annal;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Objects;

@Queue
public class AttachActor {
    private static final Annal LOGGER = Annal.get(AttachActor.class);

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u03c0\u03b5\u03c1\u03b9\u03b2\u03ac\u03bb\u03bb\u03c9\u03bd/X-UPLOAD")
    public Future<JsonObject> upload(Envelop envelop) {
        JsonObject content = envelop.body();
        At.infoFile(LOGGER, "Upload parameters: {0}", content.encodePrettily());
        Ut.ifJObject((JsonObject)content, (String[])new String[]{"metadata"});
        return Ux.future((Object)content);
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u03c0\u03b5\u03c1\u03b9\u03b2\u03ac\u03bb\u03bb\u03c9\u03bd/X-DOWNLOAD")
    public Future<Buffer> download(JsonObject filters) {
        At.infoFile(LOGGER, "Download: key = {0}", filters.encodePrettily());
        return Ux.Jooq.on(XAttachmentDao.class).fetchOneAsync(filters).compose(entity -> {
            Buffer buffer = Buffer.buffer();
            if (Objects.nonNull(entity)) {
                buffer = Ut.ioBuffer((String)entity.getFilePath());
            }
            return Ux.future((Object)buffer);
        });
    }
}

