/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.ambient.refine;

import cn.vertxup.ambient.domain.tables.pojos.XNumber;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.FileUpload;
import io.vertx.tp.ambient.refine.AtEnv;
import io.vertx.tp.ambient.refine.AtLog;
import io.vertx.tp.ambient.refine.AtSerial;
import io.vertx.tp.ambient.refine.Pool;
import io.vertx.tp.optic.extension.AppInit;
import io.vertx.tp.optic.extension.DatabaseInit;
import io.vertx.tp.optic.extension.DatumInit;
import io.vertx.tp.optic.extension.Init;
import io.vertx.tp.optic.extension.SourceInit;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.unity.Ux;
import java.util.List;

public class At {
    public static void infoInit(Annal logger, String pattern, Object ... args) {
        AtLog.info(logger, "Init", pattern, args);
    }

    public static void infoFile(Annal logger, String pattern, Object ... args) {
        AtLog.info(logger, "File", pattern, args);
    }

    public static void infoApp(Annal logger, String pattern, Object ... args) {
        AtLog.info(logger, "Application", pattern, args);
    }

    public static void infoApp(Class<?> clazz, String pattern, Object ... args) {
        Annal logger = Annal.get(clazz);
        AtLog.info(logger, "Application", pattern, args);
    }

    public static void infoFlow(Class<?> clazz, String pattern, Object ... args) {
        Annal logger = Annal.get(clazz);
        AtLog.info(logger, "Execution", pattern, args);
    }

    public static Init initApp() {
        return (Init)Fn.pool(Pool.INIT_POOL, (Object)AppInit.class.getName(), AppInit::new);
    }

    public static Init initSource() {
        return (Init)Fn.pool(Pool.INIT_POOL, (Object)SourceInit.class.getName(), SourceInit::new);
    }

    public static Init initDatabase() {
        return (Init)Fn.pool(Pool.INIT_POOL, (Object)DatabaseInit.class.getName(), DatabaseInit::new);
    }

    public static Init initData() {
        return (Init)Fn.pool(Pool.INIT_POOL, (Object)DatumInit.class.getName(), DatumInit::new);
    }

    public static List<String> generate(XNumber number, Integer count) {
        return AtSerial.generate(number, count);
    }

    public static Future<List<String>> generateAsync(XNumber number, Integer count) {
        return Ux.future(AtSerial.generate(number, count));
    }

    public static XNumber serialAdjust(XNumber number, Integer count) {
        return AtSerial.adjust(number, count);
    }

    public static JsonObject upload(String identifier, FileUpload fileUpload, String category) {
        return AtEnv.upload(identifier, fileUpload, category);
    }
}

