/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.ambient.uca.digital;

import cn.vertxup.ambient.domain.tables.daos.XTabularDao;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ambient.uca.digital.Aide;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Objects;

public abstract class AbstractAide
implements Aide {
    protected Future<JsonArray> fetchDict(JsonObject criteria) {
        return Ux.Jooq.on(XTabularDao.class).fetchAsync(criteria).compose(Ux::futureA).compose(Ut.ifJArray((String[])new String[]{"metadata"}));
    }

    protected JsonObject condApp(String appId, JsonArray types, String code) {
        JsonObject criteria = Ux.whereAnd();
        criteria.put("appId", (Object)appId);
        this.condition(criteria, types, code);
        return criteria;
    }

    protected JsonObject condApp(String appId, String type, String code) {
        return this.condApp(appId, new JsonArray().add((Object)type), code);
    }

    protected JsonObject condSigma(String sigma, JsonArray types, String code) {
        JsonObject criteria = Ux.whereAnd();
        criteria.put("sigma", (Object)sigma);
        this.condition(criteria, types, code);
        return criteria;
    }

    protected JsonObject condSigma(String sigma, String type, String code) {
        return this.condSigma(sigma, new JsonArray().add((Object)type), code);
    }

    private void condition(JsonObject criteria, JsonArray types, String code) {
        Objects.requireNonNull(criteria);
        JsonArray typeArray = Ut.valueJArray((JsonArray)types);
        criteria.put("active", (Object)Boolean.TRUE);
        if (1 == typeArray.size()) {
            String firstArg = typeArray.getString(0);
            criteria.put("type", (Object)firstArg);
            if (Ut.notNil((String)code)) {
                criteria.put("code", (Object)code);
            }
        } else {
            criteria.put("type,i", (Object)types);
        }
    }
}

