/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.optic.business;

import cn.vertxup.ambient.domain.tables.daos.XAttachmentDao;
import cn.vertxup.ambient.domain.tables.pojos.XAttachment;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ambient.refine.At;
import io.vertx.tp.optic.feature.Attachment;
import io.vertx.up.log.Annal;
import io.vertx.up.uca.jooq.UxJooq;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.List;
import java.util.Set;

public class ExAttachment
implements Attachment {
    private static final Annal LOGGER = Annal.get(ExAttachment.class);

    public Future<JsonArray> createAsync(JsonArray data) {
        Ut.ifStrings((JsonArray)data, (String[])new String[]{"metadata"});
        List attachments = Ux.fromJson((JsonArray)data, XAttachment.class);
        return Ux.Jooq.on(XAttachmentDao.class).insertJAsync(attachments);
    }

    public Future<JsonArray> saveAsync(JsonObject condition, JsonArray data) {
        Ut.ifStrings((JsonArray)data, (String[])new String[]{"metadata"});
        List attachments = Ux.fromJson((JsonArray)data, XAttachment.class);
        At.infoFile(LOGGER, "Save Operation, condition: {0}", condition);
        return this.removeAsync(condition).compose(nil -> Ux.Jooq.on(XAttachmentDao.class).insertJAsync(attachments));
    }

    public Future<Boolean> removeAsync(JsonObject condition) {
        At.infoFile(LOGGER, "Remove Operation, condition: {0}", condition);
        UxJooq jq = Ux.Jooq.on(XAttachmentDao.class);
        return jq.fetchAsync(condition).compose(attachments -> {
            Set files = Ut.elementSet((List)attachments, XAttachment::getFilePath);
            Ut.ioDelete((Set)files);
            At.infoFile(LOGGER, "Deleted files: {0}", String.valueOf(files.size()));
            return jq.deleteByAsync(condition);
        });
    }

    public Future<JsonArray> fetchAsync(JsonObject condition) {
        At.infoFile(LOGGER, "Fetch Operation, condition: {0}", condition);
        return Ux.Jooq.on(XAttachmentDao.class).fetchJAsync(condition).compose(Ut.ifJArray((String[])new String[]{"metadata"}));
    }
}

