/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.optic.environment;

import cn.vertxup.ambient.domain.tables.daos.XAppDao;
import cn.vertxup.ambient.domain.tables.daos.XSourceDao;
import cn.vertxup.ambient.domain.tables.pojos.XApp;
import cn.vertxup.ambient.domain.tables.pojos.XSource;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.tp.ambient.refine.At;
import io.vertx.tp.ke.refine.Ke;
import io.vertx.up.log.Annal;
import io.vertx.up.util.Ut;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jooq.Configuration;

class UnityAsker {
    private static final Annal LOGGER = Annal.get(UnityAsker.class);
    private static final ConcurrentMap<String, XApp> APP_POOL = new ConcurrentHashMap<String, XApp>();
    private static final ConcurrentMap<String, XSource> SOURCE_POOL = new ConcurrentHashMap<String, XSource>();

    UnityAsker() {
    }

    static Future<Boolean> init(Vertx vertx) {
        Configuration configuration = Ke.getConfiguration();
        XAppDao appDao = new XAppDao(configuration, vertx);
        return ((Future)appDao.findAll()).compose(applications -> {
            At.infoApp(LOGGER, "{0} Application have been initialized successfully!", applications.size());
            APP_POOL.putAll(Ut.elementZip((Collection)applications, XApp::getKey, app -> app));
            return Future.succeededFuture((Object)Boolean.TRUE);
        }).compose(nil -> {
            XSourceDao sourceDao = new XSourceDao(configuration, vertx);
            return (Future)sourceDao.findAll();
        }).compose(sources -> {
            At.infoApp(LOGGER, "{0} Data source have been initialized successfully!", sources.size());
            SOURCE_POOL.putAll(Ut.elementZip((Collection)sources, XSource::getAppId, source -> source));
            return Future.succeededFuture((Object)Boolean.TRUE);
        });
    }

    static ConcurrentMap<String, XApp> getApps() {
        return APP_POOL;
    }

    static ConcurrentMap<String, XSource> getSources() {
        return SOURCE_POOL;
    }
}

