/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.optic.extension;

import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.WorkerExecutor;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ambient.atom.AtConfig;
import io.vertx.tp.ambient.init.AtPin;
import io.vertx.tp.ambient.refine.At;
import io.vertx.tp.optic.extension.Init;
import io.vertx.tp.plugin.excel.ExcelClient;
import io.vertx.tp.plugin.excel.ExcelInfix;
import io.vertx.up.atom.unity.UObject;
import io.vertx.up.log.Annal;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public class DatumInit
implements Init {
    private static final Annal LOGGER = Annal.get(DatumInit.class);
    private static final AtConfig CONFIG = AtPin.getConfig();

    public Function<JsonObject, Future<JsonObject>> apply() {
        return appJson -> {
            At.infoApp(LOGGER, "Data Loading: {0}", appJson.encode());
            return this.doLoading((JsonObject)appJson).compose(this::doExtension);
        };
    }

    public Future<JsonObject> doExtension(JsonObject appJson) {
        Init loader = AtPin.getLoader();
        if (Objects.isNull(loader)) {
            return Ux.future((Object)appJson);
        }
        return (Future)loader.apply().apply(appJson);
    }

    private Future<JsonObject> doLoading(JsonObject appJson) {
        String dataFolder = CONFIG.getDataFolder();
        List files = Ut.ioFiles((String)dataFolder);
        List futures = files.stream().filter(Ut::notNil).filter(file -> !file.startsWith("~$")).map(file -> dataFolder + file).map(this::doLoading).collect(Collectors.toList());
        return Ux.thenCombine(futures).compose(results -> UObject.create().append("result", results).toFuture()).compose(results -> Ux.future((Object)this.result((JsonObject)results, appJson)));
    }

    private Future<JsonObject> doLoading(String filename) {
        Promise promise = Promise.promise();
        WorkerExecutor executor = Ux.nativeWorker((String)filename);
        executor.executeBlocking(pre -> {
            ExcelClient client = ExcelInfix.createClient();
            client.importAsync(filename, result -> {
                At.infoApp(LOGGER, "Data Loading: filename = {0}", filename);
                if (result.succeeded()) {
                    pre.complete((Object)Ux.outBool((String)filename, (boolean)Boolean.TRUE));
                } else {
                    pre.fail(result.cause());
                }
            });
        }, post -> promise.complete((Object)((JsonObject)post.result())));
        return promise.future();
    }

    public JsonObject result(JsonObject input, JsonObject appJson) {
        return appJson;
    }
}

