/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.ambient.api;

import cn.vertxup.ambient.domain.tables.daos.XActivityDao;
import cn.vertxup.ambient.service.ActivityStub;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.annotations.Address;
import io.vertx.up.annotations.Queue;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Objects;
import javax.inject.Inject;

@Queue
public class HistoryActor {
    @Inject
    private transient ActivityStub activityStub;

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u03c0\u03b5\u03c1\u03b9\u03b2\u03ac\u03bb\u03bb\u03c9\u03bd/X-ACTIVITY/HISTORIES")
    public Future<JsonArray> fetchHistory(String identifier, String key) {
        if (Ut.isNilOr((String[])new String[]{identifier, key})) {
            return Ux.futureA();
        }
        return this.activityStub.fetchActivities(identifier, key);
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u03c0\u03b5\u03c1\u03b9\u03b2\u03ac\u03bb\u03bb\u03c9\u03bd/X-ACTIVITY/HISTORY-ITEMS")
    public Future<JsonArray> fetchChanges(String activityId) {
        return this.activityStub.fetchChanges(activityId);
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u03c0\u03b5\u03c1\u03b9\u03b2\u03ac\u03bb\u03bb\u03c9\u03bd/X-ACTIVITY/HISTORY-BY-FIELDS")
    public Future<JsonArray> fetchChangeBy(String modelId, String modelKey, String modelField) {
        if (Ut.isNilOr((String[])new String[]{modelId, modelKey, modelField})) {
            return Ux.futureA();
        }
        return this.activityStub.fetchActivities(modelId, modelKey, modelField);
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u03c0\u03b5\u03c1\u03b9\u03b2\u03ac\u03bb\u03bb\u03c9\u03bd/X-ACTIVITY/SEARCH")
    public Future<JsonObject> searchActivities(JsonObject body) {
        return Ux.Jooq.on(XActivityDao.class).searchAsync(body);
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u03c0\u03b5\u03c1\u03b9\u03b2\u03ac\u03bb\u03bb\u03c9\u03bd/X-ACTIVITY/GET")
    public Future<JsonObject> fetchActivity(String key) {
        return Ux.Jooq.on(XActivityDao.class).fetchByIdAsync((Object)key).compose(activity -> {
            if (Objects.isNull(activity)) {
                return Ux.futureJ();
            }
            return this.activityStub.fetchChanges(activity.getKey()).compose(changes -> {
                JsonObject data = Ux.toJson((Object)activity);
                Ut.ifJObject((JsonObject)data, (String[])new String[]{"recordNew", "recordOld"});
                data.put("changes", changes);
                return Ux.future((Object)data);
            });
        });
    }
}

