/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.ambient.api.linkage;

import cn.vertxup.ambient.domain.tables.daos.XLinkageDao;
import cn.vertxup.ambient.service.linkage.LinkStub;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.annotations.Address;
import io.vertx.up.annotations.Me;
import io.vertx.up.annotations.Queue;
import io.vertx.up.commune.config.XHeader;
import io.vertx.up.uca.jooq.UxJooq;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import javax.inject.Inject;

@Queue
public class LinkActor {
    @Inject
    private transient LinkStub stub;

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u03c0\u03b5\u03c1\u03b9\u03b2\u03ac\u03bb\u03bb\u03c9\u03bd/X-LINKAGE/BY/TYPE")
    public Future<JsonArray> fetchBy(String type, XHeader header) {
        return this.stub.fetchByType(type, header.getSigma());
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u03c0\u03b5\u03c1\u03b9\u03b2\u03ac\u03bb\u03bb\u03c9\u03bd/X-LINKAGE/TARGET/FETCH")
    public Future<JsonArray> fetchTarget(String key) {
        return this.stub.fetchNorm(key, null);
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u03c0\u03b5\u03c1\u03b9\u03b2\u03ac\u03bb\u03bb\u03c9\u03bd/X-LINKAGE/SOURCE/FETCH")
    public Future<JsonArray> fetchSource(String key) {
        return this.stub.fetchNorm(null, key);
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u03c0\u03b5\u03c1\u03b9\u03b2\u03ac\u03bb\u03bb\u03c9\u03bd/X-LINKAGE/T-S/FETCH")
    public Future<JsonArray> fetchSt(String key) {
        return this.stub.fetchNorm(key, key);
    }

    @Me
    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u03c0\u03b5\u03c1\u03b9\u03b2\u03ac\u03bb\u03bb\u03c9\u03bd/X-LINKAGE/BATCH/SAVING-B")
    public Future<JsonArray> batchSaveB(JsonArray data) {
        return this.stub.saving(data, false);
    }

    @Me
    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u03c0\u03b5\u03c1\u03b9\u03b2\u03ac\u03bb\u03bb\u03c9\u03bd/X-LINKAGE/BATCH/SAVING-V")
    public Future<JsonArray> batchSaveV(JsonArray data) {
        return this.stub.saving(data, true);
    }

    @Me
    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u03c0\u03b5\u03c1\u03b9\u03b2\u03ac\u03bb\u03bb\u03c9\u03bd/X-LINKAGE/ADD/NEW-B")
    public Future<JsonObject> addNewB(JsonObject data) {
        return this.stub.create(data, false);
    }

    @Me
    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u03c0\u03b5\u03c1\u03b9\u03b2\u03ac\u03bb\u03bb\u03c9\u03bd/X-LINKAGE/ADD/NEW-V")
    public Future<JsonObject> addNewV(JsonObject data) {
        return this.stub.create(data, true);
    }

    @Me
    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u03c0\u03b5\u03c1\u03b9\u03b2\u03ac\u03bb\u03bb\u03c9\u03bd/X-LINKAGE/SYNC-B")
    public Future<JsonArray> syncB(JsonObject request) {
        JsonArray data = Ut.valueJArray((JsonObject)request, (String)"data");
        JsonArray removed = Ut.valueJArray((JsonObject)request, (String)"removed");
        Ut.itJArray((JsonArray)data).forEach(json -> {
            Ut.elementCopy((JsonObject)json, (JsonObject)request, (String[])new String[]{"active", "language", "sigma", "updatedBy", "updatedAt"});
            if (!json.containsKey("createdBy")) {
                json.put("createdAt", request.getValue("updatedAt"));
                json.put("createdBy", request.getValue("updatedBy"));
            }
        });
        return this.stub.syncB(data, removed);
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u03c0\u03b5\u03c1\u03b9\u03b2\u03ac\u03bb\u03bb\u03c9\u03bd/X-LINKAGE/KEY/FETCH")
    public Future<JsonObject> byKey(String key) {
        return Ux.Jooq.on(XLinkageDao.class).fetchJByIdAsync((Object)key);
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u03c0\u03b5\u03c1\u03b9\u03b2\u03ac\u03bb\u03bb\u03c9\u03bd/X-LINKAGE/REGION/REMOVE")
    public Future<Boolean> removeKey(String key, XHeader header) {
        UxJooq jooq = Ux.Jooq.on(XLinkageDao.class);
        JsonObject criteria = Ux.whereAnd();
        criteria.put("region", (Object)key);
        criteria.put("sigma", (Object)header.getSigma());
        return jooq.deleteByAsync(criteria);
    }
}

