/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.ambient.service.application;

import cn.vertxup.ambient.domain.tables.daos.XMenuDao;
import cn.vertxup.ambient.domain.tables.daos.XMenuMyDao;
import cn.vertxup.ambient.domain.tables.pojos.XMenuMy;
import cn.vertxup.ambient.service.application.MenuStub;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ambient.refine.At;
import io.vertx.up.uca.jooq.UxJooq;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.List;

public class MenuService
implements MenuStub {
    @Override
    public Future<JsonArray> fetchByApp(String appId) {
        return Ux.Jooq.on(XMenuDao.class).fetchJAsync("appId", (Object)appId).compose(Ut.ifJArray((String[])new String[]{"metadata"}));
    }

    @Override
    public Future<JsonArray> fetchMy(JsonObject condition) {
        condition.put("", (Object)Boolean.TRUE);
        At.infoFlow(this.getClass(), "My menu condition: {0}", condition.encode());
        return Ux.Jooq.on(XMenuMyDao.class).fetchJAsync(condition);
    }

    @Override
    public Future<JsonArray> saveMy(JsonObject condition, JsonArray data) {
        At.infoFlow(this.getClass(), "My menu saving: {0}, data = {1}", condition.encode(), data.encode());
        UxJooq jooq = Ux.Jooq.on(XMenuMyDao.class);
        return jooq.deleteByAsync(condition).compose(removed -> {
            List menus = Ux.fromJson((JsonArray)data, XMenuMy.class);
            return jooq.insertJAsync(menus);
        });
    }
}

