/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.ambient.service.linkage;

import cn.vertxup.ambient.domain.tables.daos.XLinkageDao;
import cn.vertxup.ambient.domain.tables.pojos.XLinkage;
import cn.vertxup.ambient.service.linkage.LinkStub;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.uca.jooq.UxJooq;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

public class LinkService
implements LinkStub {
    @Override
    public Future<JsonArray> fetchByType(String type, String sigma) {
        Objects.requireNonNull(sigma);
        JsonObject criteria = Ux.whereAnd();
        criteria.put("sigma", (Object)sigma);
        if (Ut.notNil((String)type)) {
            criteria.put("type", (Object)type);
        }
        return Ux.Jooq.on(XLinkageDao.class).fetchJAsync(criteria);
    }

    @Override
    public Future<JsonArray> fetchNorm(String sourceKey, String targetKey) {
        if (Ut.isNil((String)sourceKey) && Ut.isNil((String)targetKey)) {
            return Ux.futureA();
        }
        JsonObject criteria = Ux.whereOr();
        if (Ut.notNil((String)sourceKey)) {
            criteria.put("sourceKey", (Object)sourceKey);
        }
        if (Ut.notNil((String)targetKey)) {
            criteria.put("targetKey", (Object)targetKey);
        }
        return Ux.Jooq.on(XLinkageDao.class).fetchJAsync(criteria);
    }

    @Override
    public Future<JsonArray> saving(JsonArray batchData, boolean vector) {
        ArrayList queueA = new ArrayList();
        ArrayList queueU = new ArrayList();
        Ut.itJArray((JsonArray)batchData).forEach(json -> {
            this.calcData((JsonObject)json, "sourceData");
            this.calcData((JsonObject)json, "targetData");
            if (json.containsKey("linkKey")) {
                queueU.add((XLinkage)Ux.fromJson((JsonObject)json, XLinkage.class));
            } else {
                json.remove("key");
                this.calcKey((JsonObject)json, vector);
                queueA.add((XLinkage)Ux.fromJson((JsonObject)json, XLinkage.class));
            }
        });
        UxJooq jooq = Ux.Jooq.on(XLinkageDao.class);
        ArrayList<Future> futures = new ArrayList<Future>();
        futures.add(jooq.insertAsync(queueA));
        futures.add(jooq.updateAsync(queueU));
        return Ux.thenCombineArrayT(futures).compose(Ux::futureA).compose(Ut.ifJArray((String[])new String[]{"sourceData", "targetData"}));
    }

    @Override
    public Future<JsonArray> syncB(JsonArray data, JsonArray removed) {
        JsonObject condition = new JsonObject();
        condition.put("key,i", (Object)removed);
        return Ux.Jooq.on(XLinkageDao.class).deleteByAsync(condition).compose(deleted -> this.saving(data, false));
    }

    @Override
    public Future<JsonObject> create(JsonObject data, boolean vector) {
        this.calcKey(data, vector);
        return Ux.Jooq.on(XLinkageDao.class).insertJAsync(data);
    }

    private void calcData(JsonObject json, String field) {
        if (json.containsKey(field)) {
            Object value = json.getValue(field);
            if (value instanceof JsonObject) {
                json.put(field, (Object)((JsonObject)value).encode());
            } else if (value instanceof JsonArray) {
                json.put(field, (Object)((JsonArray)value).encode());
            }
        }
    }

    private void calcKey(JsonObject json, boolean vector) {
        String seed;
        AbstractCollection keys;
        String sourceKey = json.getString("sourceKey");
        String targetKey = json.getString("targetKey");
        if (vector) {
            keys = new ArrayList();
            keys.add(sourceKey);
            keys.add(targetKey);
            seed = Ut.fromJoin((List)((Object)keys), (String)"-");
        } else {
            keys = new TreeSet();
            keys.add(sourceKey);
            keys.add(targetKey);
            seed = Ut.fromJoin((Set)((Object)keys), (String)"-");
        }
        String linkKey = Ut.encryptMD5((String)seed);
        json.put("linkKey", (Object)linkKey);
    }
}

