/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.ambient.cache;

import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.up.log.Debugger;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;

class AcModule {
    private static final ConcurrentMap<String, JsonObject> CACHE_MODULE = new ConcurrentHashMap<String, JsonObject>();

    AcModule() {
    }

    static Future<JsonObject> getModule(JsonObject condition, Supplier<Future<JsonObject>> executor) {
        String appId = condition.getString("appId");
        String entry = condition.getString("entry");
        if (Ut.isNilOr((String[])new String[]{appId, entry})) {
            return Ux.futureJ();
        }
        String cacheKey = appId + ":" + entry;
        if (Debugger.onUiCache()) {
            JsonObject cachedData = CACHE_MODULE.getOrDefault(cacheKey, null);
            if (Objects.isNull(cachedData)) {
                return executor.get().compose(dataData -> {
                    if (Objects.nonNull(dataData)) {
                        CACHE_MODULE.put(cacheKey, (JsonObject)dataData);
                    }
                    return Ux.future((Object)dataData);
                });
            }
            return Ux.future((Object)cachedData);
        }
        return executor.get();
    }
}

