/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.ambient.refine;

import cn.vertxup.ambient.domain.tables.pojos.XNumber;
import io.vertx.core.json.JsonObject;
import io.vertx.up.util.Ut;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

class AtSerial {
    AtSerial() {
    }

    static List<String> generate(XNumber number, Integer count) {
        ArrayList<String> numbers = new ArrayList<String>();
        JsonObject params = new JsonObject();
        if (null != number.getPrefix()) {
            params.put("prefix", (Object)number.getPrefix());
        }
        if (null != number.getSuffix()) {
            params.put("suffix", (Object)number.getSuffix());
        }
        Long seed = number.getCurrent();
        for (int idx = 0; idx < count; ++idx) {
            JsonObject paramMap = params.copy();
            String time = AtSerial.getTime(number);
            if (Ut.notNil((String)time)) {
                paramMap.put("time", (Object)time);
            }
            String seedStr = AtSerial.getSeed(number, seed);
            paramMap.put("seed", (Object)seedStr);
            seed = AtSerial.getNext(number, seed);
            String result = Ut.fromExpression((String)number.getFormat(), (JsonObject)paramMap);
            numbers.add(result);
        }
        return numbers;
    }

    static XNumber adjust(XNumber number, Integer count) {
        boolean renewal = !Objects.isNull(number.getRenewal()) && number.getRenewal() != false;
        int step = Objects.isNull(number.getStep()) ? 1 : number.getStep();
        long adjust = (long)count.intValue() * (long)step;
        boolean decrement = Objects.isNull(number.getDecrement()) || number.getDecrement() != false;
        long result = decrement ? number.getCurrent() - adjust : number.getCurrent() + adjust;
        if (renewal) {
            Objects.requireNonNull(number.getTime());
            int length = Objects.requireNonNull(number.getLength());
            if (0 < length) {
                StringBuilder digest = new StringBuilder();
                Ut.itRepeat((Integer)length, () -> digest.append("9"));
                long max = Long.parseLong(digest.toString());
                if (result > max) {
                    result = 1L;
                }
            }
        }
        number.setCurrent(result);
        return number;
    }

    private static Long getNext(XNumber number, Long current) {
        Integer step = number.getStep();
        Boolean decrement = number.getDecrement();
        long seed = decrement != false ? current - (long)step.intValue() : current + (long)step.intValue();
        return seed;
    }

    private static String getSeed(XNumber number, Long current) {
        Long seed = AtSerial.getNext(number, current);
        return Ut.fromAdjust((Integer)Integer.parseInt(seed.toString()), (Integer)number.getLength());
    }

    private static String getTime(XNumber number) {
        String literal = "";
        if (!Objects.isNull(number.getTime())) {
            SimpleDateFormat format = new SimpleDateFormat(number.getTime());
            literal = format.format(new Date());
        }
        return literal;
    }
}

