/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.optic;

import io.vertx.core.json.JsonObject;
import io.vertx.tp.ambient.refine.At;
import io.vertx.tp.ke.atom.KEnv;
import io.vertx.tp.optic.environment.ES;
import io.vertx.tp.optic.environment.UnityAmbient;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class AtomHighway
implements ES {
    private static final ConcurrentMap<String, KEnv> CACHE_BY_KEY = new ConcurrentHashMap<String, KEnv>();
    private static final ConcurrentMap<String, KEnv> CACHE_BY_SIGMA = new ConcurrentHashMap<String, KEnv>();

    public KEnv connect(String id) {
        this.initialize();
        KEnv env = CACHE_BY_SIGMA.getOrDefault(id, null);
        if (Objects.isNull(env)) {
            env = CACHE_BY_KEY.getOrDefault(id, null);
        }
        return env;
    }

    public KEnv connect() {
        this.initialize();
        KEnv env = null;
        if (1 == CACHE_BY_KEY.size()) {
            env = (KEnv)CACHE_BY_KEY.values().iterator().next();
        }
        if (Objects.isNull(env) && 1 == CACHE_BY_SIGMA.size()) {
            env = (KEnv)CACHE_BY_SIGMA.values().iterator().next();
        }
        return env;
    }

    private void initialize() {
        if (CACHE_BY_KEY.isEmpty()) {
            UnityAmbient app = new UnityAmbient();
            ConcurrentMap appMap = app.connect();
            At.infoApp(this.getClass(), "[KEnv] Environment connecting..., size = {0}", String.valueOf(appMap.size()));
            appMap.forEach((appId, json) -> {
                KEnv env = KEnv.instance((JsonObject)json);
                CACHE_BY_KEY.put((String)appId, env);
                CACHE_BY_SIGMA.put(env.sigma(), env);
            });
        }
    }
}

