/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.optic.environment;

import cn.vertxup.ambient.domain.tables.pojos.XApp;
import cn.vertxup.ambient.domain.tables.pojos.XSource;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.optic.environment.UnityApp;
import io.vertx.tp.optic.environment.UnityAsker;
import io.vertx.up.fn.Fn;
import io.vertx.up.util.Ut;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class UnityAmbient
implements UnityApp {
    private static final ConcurrentMap<String, JsonObject> UNITY_POOL = new ConcurrentHashMap<String, JsonObject>();

    public Future<Boolean> initialize(Vertx vertx) {
        return UnityAsker.init(vertx).compose(nil -> {
            ConcurrentMap<String, XApp> apps = UnityAsker.getApps();
            ConcurrentMap<String, XSource> sources = UnityAsker.getSources();
            apps.keySet().stream().filter(appId -> Objects.nonNull(apps.get(appId))).filter(appId -> Objects.nonNull(sources.get(appId))).map(appId -> this.connect((XApp)apps.get(appId), (XSource)sources.get(appId))).forEach(item -> UNITY_POOL.put(item.getString("appId"), (JsonObject)item));
            return Future.succeededFuture((Object)Boolean.TRUE);
        });
    }

    public ConcurrentMap<String, JsonObject> connect() {
        return UNITY_POOL;
    }

    private JsonObject connect(XApp app, XSource source) {
        JsonObject normalized = new JsonObject();
        normalized.put("appId", (Object)app.getKey());
        normalized.put("appKey", (Object)app.getAppKey());
        normalized.put("sigma", (Object)app.getSigma());
        normalized.put("name", (Object)app.getName());
        normalized.put("code", (Object)app.getCode());
        normalized.put("language", (Object)app.getLanguage());
        normalized.put("active", (Object)app.getActive());
        normalized.put("logo", (Object)app.getLogo());
        normalized.put("title", (Object)app.getTitle());
        JsonObject business = new JsonObject();
        business.put("icp", (Object)app.getIcp());
        business.put("email", (Object)app.getEmail());
        business.put("copyRight", (Object)app.getCopyRight());
        normalized.put("business", (Object)business);
        JsonObject backend = new JsonObject();
        backend.put("domain", (Object)app.getDomain());
        backend.put("appPort", (Object)app.getAppPort());
        backend.put("route", (Object)app.getRoute());
        normalized.put("backend", (Object)backend);
        JsonObject frontend = new JsonObject();
        frontend.put("path", (Object)app.getPath());
        frontend.put("urlEntry", (Object)app.getUrlEntry());
        frontend.put("urlMain", (Object)app.getUrlMain());
        normalized.put("frontend", (Object)frontend);
        JsonObject auditor = new JsonObject();
        auditor.put("createdBy", (Object)app.getCreatedBy());
        Fn.safeNull(() -> auditor.put("createdAt", (Object)Ut.parse((LocalDateTime)app.getCreatedAt()).toInstant()), (Object[])new Object[]{app.getCreatedAt()});
        auditor.put("updatedBy", (Object)app.getUpdatedBy());
        Fn.safeNull(() -> auditor.put("updatedAt", (Object)Ut.parse((LocalDateTime)app.getUpdatedAt()).toInstant()), (Object[])new Object[]{app.getUpdatedAt()});
        normalized.put("auditor", (Object)auditor);
        JsonObject sourceJson = new JsonObject();
        sourceJson.put("hostname", (Object)source.getHostname());
        sourceJson.put("instance", (Object)source.getInstance());
        sourceJson.put("port", (Object)source.getPort());
        sourceJson.put("category", (Object)source.getCategory());
        sourceJson.put("jdbcUrl", (Object)source.getJdbcUrl());
        sourceJson.put("username", (Object)source.getUsername());
        sourceJson.put("password", (Object)source.getPassword());
        sourceJson.put("driverClassName", (Object)source.getDriverClassName());
        String jdbcConfig = source.getJdbcConfig();
        if (Ut.notNil((String)jdbcConfig)) {
            sourceJson.put("options", (Object)Ut.toJObject((String)jdbcConfig));
        }
        normalized.put("source", (Object)sourceJson);
        return normalized;
    }
}

