/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.optic.extension;

import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ambient.refine.At;
import io.vertx.tp.optic.extension.Init;
import io.vertx.up.commune.config.Database;
import io.vertx.up.log.Annal;
import io.vertx.up.uca.cache.Rapid;
import io.vertx.up.unity.Ux;
import java.util.function.Function;

public class DatabaseInit
implements Init {
    private static final Annal LOGGER = Annal.get(DatabaseInit.class);

    public Function<JsonObject, Future<JsonObject>> apply() {
        return appJson -> {
            At.infoApp(LOGGER, "Database initialization: {0}", appJson.encode());
            JsonObject databaseJson = appJson.getJsonObject("source");
            Database database = new Database();
            database.fromJson(databaseJson);
            return Rapid.t((String)"ZERO-CACHE-DATABASE").write((Object)appJson.getString("key"), (Object)database).compose(item -> Ux.future((Object)item.toJson())).compose(item -> Ux.future((Object)this.result((JsonObject)appJson, (JsonObject)item)));
        };
    }

    public JsonObject result(JsonObject input, JsonObject database) {
        At.infoApp(LOGGER, "Workflow for database: {0}", database.encodePrettily());
        return input;
    }
}

