/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.ambient.api.application;

import cn.vertxup.ambient.domain.tables.daos.XNoticeDao;
import cn.vertxup.ambient.service.application.AppStub;
import cn.vertxup.ambient.service.application.MenuStub;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.annotations.Address;
import io.vertx.up.annotations.Queue;
import io.vertx.up.commune.config.Database;
import io.vertx.up.commune.config.XHeader;
import io.vertx.up.uca.jooq.UxJooq;
import io.vertx.up.unity.Ux;
import java.time.Instant;
import java.util.function.Function;
import javax.inject.Inject;

@Queue
public class AppActor {
    @Inject
    private transient AppStub appStub;
    @Inject
    private transient MenuStub menuStub;

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u03c0\u03b5\u03c1\u03b9\u03b2\u03ac\u03bb\u03bb\u03c9\u03bd/X-APP/BY-NAME")
    public Future<JsonObject> byName(String name) {
        return this.appStub.fetchByName(name);
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u03c0\u03b5\u03c1\u03b9\u03b2\u03ac\u03bb\u03bb\u03c9\u03bd/X-APP/BY-ID")
    public Future<JsonObject> byId(String appId, XHeader header) {
        return this.appStub.fetchById(appId);
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u03c0\u03b5\u03c1\u03b9\u03b2\u03ac\u03bb\u03bb\u03c9\u03bd/X-MENU/APP-ID")
    public Future<JsonArray> fetchMenus(String appId) {
        return this.menuStub.fetchByApp(appId);
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u03c0\u03b5\u03c1\u03b9\u03b2\u03ac\u03bb\u03bb\u03c9\u03bd/X-APP/UPDATE/BY-ID")
    public Future<JsonObject> updateBy(String appId, JsonObject data) {
        return this.appStub.updateBy(appId, data);
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u03c0\u03b5\u03c1\u03b9\u03b2\u03ac\u03bb\u03bb\u03c9\u03bd/X-SOURCE")
    public Future<JsonObject> database(String appId) {
        return this.appStub.fetchSource(appId).compose(atom -> {
            Function<JsonObject, JsonObject> consumer = json -> {
                json.remove("password");
                json.remove("username");
                return json;
            };
            Database current = Database.getCurrent();
            Database orbit = Database.getHistory();
            Database workflow = Database.getCamunda();
            JsonObject response = new JsonObject();
            response.put("database", (Object)consumer.apply(current.toJson()));
            response.put("history", (Object)consumer.apply(orbit.toJson()));
            response.put("workflow", (Object)consumer.apply(workflow.toJson()));
            response.put("atom", (Object)consumer.apply((JsonObject)atom));
            return Ux.future((Object)response);
        });
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u03c0\u03b5\u03c1\u03b9\u03b2\u03ac\u03bb\u03bb\u03c9\u03bd/X-NOTICE")
    public Future<JsonArray> notice(String appId, JsonObject criteria) {
        JsonObject expiredQr = Ux.whereAnd();
        expiredQr.put("expiredAt,<", (Object)Instant.now());
        expiredQr.put("appId", (Object)appId);
        UxJooq jq = Ux.Jooq.on(XNoticeDao.class);
        return jq.fetchAsync(expiredQr).compose(notices -> {
            notices.forEach(notice -> notice.setStatus("FINISHED"));
            return jq.updateAsync(notices);
        }).compose(nil -> {
            JsonObject dashboardQr = Ux.whereAnd();
            dashboardQr.put("appId", (Object)appId);
            dashboardQr.put("$IN$", (Object)criteria);
            return jq.fetchJAsync(dashboardQr);
        });
    }
}

