/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.ambient.api.file;

import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.FileUpload;
import io.vertx.tp.ambient.atom.AtConfig;
import io.vertx.tp.ambient.init.AtPin;
import io.vertx.tp.ke.cv.em.FileStatus;
import io.vertx.up.annotations.Address;
import io.vertx.up.annotations.EndPoint;
import io.vertx.up.util.Ut;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.StreamParam;
import java.text.MessageFormat;
import java.util.UUID;

@EndPoint
@Path(value="/api")
public class AttachAgent {
    @Path(value="/file/upload/{identifier}")
    @POST
    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u03c0\u03b5\u03c1\u03b9\u03b2\u03ac\u03bb\u03bb\u03c9\u03bd/X-UPLOAD")
    public JsonObject upload(@PathParam(value="identifier") String identifier, @QueryParam(value="category") String category, @QueryParam(value="directory") String directory, @StreamParam FileUpload fileUpload) {
        JsonObject uploaded = new JsonObject();
        String originalFile = fileUpload.fileName();
        if (Ut.isNotNil((String)originalFile) && originalFile.contains(".")) {
            AtConfig config = AtPin.getConfig();
            int lastIndex = originalFile.lastIndexOf(46);
            String fileName = originalFile.substring(0, lastIndex);
            String extension = originalFile.substring(lastIndex + 1);
            String key = UUID.randomUUID().toString();
            String downloadUrl = MessageFormat.format("/api/file/download/{0}", key);
            uploaded.put("key", (Object)key).put("status", (Object)FileStatus.DONE.name()).put("type", (Object)fileUpload.contentType()).put("mime", (Object)fileUpload.contentType()).put("name", (Object)originalFile).put("fileKey", (Object)Ut.randomString((int)64)).put("fileName", (Object)fileName).put("extension", (Object)extension).put("size", (Object)fileUpload.size()).put("fileUrl", (Object)downloadUrl).put("filePath", (Object)fileUpload.uploadedFileName()).put("modelId", (Object)identifier).put("modelCategory", (Object)category).put("language", (Object)config.getFileLanguage()).put("metadata", (Object)new JsonObject().encode()).put("storeWay", (Object)config.getFileStorage()).put("directory", (Object)directory);
        }
        return uploaded;
    }

    @Path(value="/file/download/{fileKey}")
    @GET
    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u03c0\u03b5\u03c1\u03b9\u03b2\u03ac\u03bb\u03bb\u03c9\u03bd/X-DOWNLOAD")
    @Produces(value={"application/octet-stream"})
    @Consumes(value={"application/octet-stream"})
    public JsonObject download(@PathParam(value="fileKey") String key) {
        return new JsonObject().put("key", (Object)key);
    }
}

