/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.ambient.api.file;

import cn.vertxup.ambient.service.file.DocBStub;
import cn.vertxup.ambient.service.file.DocRStub;
import cn.vertxup.ambient.service.file.DocWStub;
import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.up.annotations.Address;
import io.vertx.up.annotations.Me;
import io.vertx.up.annotations.Queue;
import io.vertx.up.commune.config.XHeader;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import javax.inject.Inject;

@Queue
public class DocActor {
    @Inject
    private transient DocRStub reader;
    @Inject
    private transient DocWStub writer;
    @Inject
    private transient DocBStub builder;

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u03c0\u03b5\u03c1\u03b9\u03b2\u03ac\u03bb\u03bb\u03c9\u03bd/X-DOCUMENT/DOCUMENT")
    public Future<JsonArray> start(String type, String appId) {
        return this.builder.initialize(appId, type);
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u03c0\u03b5\u03c1\u03b9\u03b2\u03ac\u03bb\u03bb\u03c9\u03bd/X-ATTACHMENT/BY/DIRECTORY")
    public Future<JsonArray> byDirectory(String directoryId, XHeader header) {
        return this.reader.fetchDoc(header.getSigma(), directoryId);
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u03c0\u03b5\u03c1\u03b9\u03b2\u03ac\u03bb\u03bb\u03c9\u03bd/X-ATTACHMENT/BY/KEYWORD")
    public Future<JsonArray> byKeyword(String keyword, XHeader header) {
        return this.reader.searchDoc(header.getSigma(), keyword);
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u03c0\u03b5\u03c1\u03b9\u03b2\u03ac\u03bb\u03bb\u03c9\u03bd/X-ATTACHMENT/BY/TRASHED")
    public Future<JsonArray> byTrashed(XHeader header) {
        return this.reader.fetchTrash(header.getSigma());
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u03c0\u03b5\u03c1\u03b9\u03b2\u03ac\u03bb\u03bb\u03c9\u03bd/X-ATTACHMENT/DOWNLOAD-BATCH")
    public Future<Buffer> download(JsonArray keys) {
        return this.reader.downloadDoc(Ut.toSet((JsonArray)keys));
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u03c0\u03b5\u03c1\u03b9\u03b2\u03ac\u03bb\u03bb\u03c9\u03bd/X-ATTACHMENT/RENAME")
    public Future<JsonObject> rename(JsonObject documentJ, User user) {
        String userKey = Ux.keyUser((User)user);
        documentJ.put("updatedBy", (Object)userKey);
        return this.writer.rename(documentJ);
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u03c0\u03b5\u03c1\u03b9\u03b2\u03ac\u03bb\u03bb\u03c9\u03bd/X-ATTACHMENT/UPLOAD-CREATION")
    @Me
    public Future<JsonArray> upload(JsonArray documentA) {
        return this.writer.upload(documentA);
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u03c0\u03b5\u03c1\u03b9\u03b2\u03ac\u03bb\u03bb\u03c9\u03bd/X-DOCUMENT/TRASH")
    public Future<JsonArray> trashIn(JsonArray documentA, User user) {
        String userKey = Ux.keyUser((User)user);
        Ut.itJArray((JsonArray)documentA).forEach(document -> document.put("updatedBy", (Object)userKey));
        return this.writer.trashIn(documentA);
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u03c0\u03b5\u03c1\u03b9\u03b2\u03ac\u03bb\u03bb\u03c9\u03bd/X-DOCUMENT/PURGE")
    public Future<JsonArray> trashKo(JsonArray documentA) {
        return this.writer.trashKo(documentA);
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u03c0\u03b5\u03c1\u03b9\u03b2\u03ac\u03bb\u03bb\u03c9\u03bd/X-DOCUMENT/ROLLBACK")
    public Future<JsonArray> trashOut(JsonArray documentA, User user) {
        String userKey = Ux.keyUser((User)user);
        Ut.itJArray((JsonArray)documentA).forEach(document -> document.put("updatedBy", (Object)userKey));
        return this.writer.trashOut(documentA);
    }
}

