/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.ambient.service;

import cn.vertxup.ambient.domain.tables.daos.XActivityChangeDao;
import cn.vertxup.ambient.domain.tables.pojos.XActivityChange;
import cn.vertxup.ambient.service.ActivityStub;
import io.horizon.spi.business.ExActivity;
import io.horizon.spi.business.ExActivityTracker;
import io.horizon.uca.cache.Cc;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ambient.cv.em.ActivityStatus;
import io.vertx.up.uca.jooq.UxJooq;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.ArrayList;

public class ActivityService
implements ActivityStub {
    private static final Cc<String, ExActivity> CC_ACTIVITY = Cc.openThread();

    @Override
    public Future<JsonArray> fetchActivities(String identifier, String key) {
        ExActivity activity = (ExActivity)CC_ACTIVITY.pick(ExActivityTracker::new);
        return activity.activities(identifier, key);
    }

    @Override
    public Future<JsonArray> fetchChanges(String identifier, String key, String field) {
        ExActivity activity = (ExActivity)CC_ACTIVITY.pick(ExActivityTracker::new);
        return activity.changes(identifier, key, field);
    }

    @Override
    public Future<JsonArray> fetchChanges(String activityId) {
        ExActivity activity = (ExActivity)CC_ACTIVITY.pick(ExActivityTracker::new);
        return activity.changes(activityId);
    }

    @Override
    public Future<JsonObject> fetchActivity(String id) {
        ExActivity activity = (ExActivity)CC_ACTIVITY.pick(ExActivityTracker::new);
        return activity.activity(id);
    }

    @Override
    public Future<JsonArray> saveChanges(String id, ActivityStatus status) {
        UxJooq jq = Ux.Jooq.on(XActivityChangeDao.class);
        return jq.fetchAsync("activityId", (Object)id).compose(changes -> {
            ArrayList original = new ArrayList(changes);
            Ut.itList(original, (change, index) -> {
                String oldStatus = change.getStatus();
                XActivityChange itemRef = (XActivityChange)changes.get((int)index);
                if (Ut.isNil((String)oldStatus)) {
                    itemRef.setStatus(status.name());
                } else if (ActivityStatus.CONFIRMED == status) {
                    ActivityStatus old = (ActivityStatus)Ut.toEnum(change::getStatus, ActivityStatus.class, (Enum)ActivityStatus.SYSTEM);
                    if (ActivityStatus.PENDING == old) {
                        itemRef.setStatus(ActivityStatus.CONFIRMED.name());
                    }
                } else {
                    itemRef.setStatus(status.name());
                }
            });
            return jq.updateAsync(changes).compose(Ux::futureA);
        });
    }
}

