/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.ambient.service;

import cn.vertxup.ambient.service.DatumStub;
import io.horizon.uca.cache.Cc;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ambient.refine.At;
import io.vertx.tp.ambient.uca.digital.Aide;
import io.vertx.tp.ambient.uca.digital.AideApp;
import io.vertx.tp.ambient.uca.digital.AideSigma;
import io.vertx.tp.ambient.uca.digital.Serial;
import io.vertx.tp.ambient.uca.digital.SerialGen;
import io.vertx.tp.ambient.uca.digital.Tree;
import io.vertx.tp.ambient.uca.digital.TreeApp;
import io.vertx.tp.ambient.uca.digital.TreeSigma;

public class DatumService
implements DatumStub {
    private static final Cc<String, Aide> CC_AIDE = Cc.open();
    private static final Cc<String, Tree> CC_TREE = Cc.open();
    private static final Cc<String, SerialGen> CC_SERIAL = Cc.open();

    @Override
    public Future<JsonArray> dictApp(String appId, String type) {
        Aide aide = (Aide)CC_AIDE.pick(AideApp::new, (Object)appId);
        return aide.fetch(appId, new JsonArray().add((Object)type));
    }

    @Override
    public Future<JsonArray> dictApp(String appId, JsonArray types) {
        Aide aide = (Aide)CC_AIDE.pick(AideApp::new, (Object)appId);
        return aide.fetch(appId, types);
    }

    @Override
    public Future<JsonObject> dictApp(String appId, String type, String code) {
        Aide aide = (Aide)CC_AIDE.pick(AideApp::new, (Object)appId);
        return aide.fetch(appId, type, code);
    }

    @Override
    public Future<JsonArray> dictSigma(String sigma, JsonArray types) {
        Aide aide = (Aide)CC_AIDE.pick(AideSigma::new, (Object)sigma);
        return aide.fetch(sigma, types);
    }

    @Override
    public Future<JsonArray> dictSigma(String sigma, String type) {
        Aide aide = (Aide)CC_AIDE.pick(AideSigma::new, (Object)sigma);
        return aide.fetch(sigma, new JsonArray().add((Object)type));
    }

    @Override
    public Future<JsonObject> dictSigma(String sigma, String type, String code) {
        Aide aide = (Aide)CC_AIDE.pick(AideSigma::new, (Object)sigma);
        return aide.fetch(sigma, type, code);
    }

    @Override
    public Future<JsonArray> treeApp(String appId, String type, Boolean leaf) {
        Tree tree = (Tree)CC_TREE.pick(TreeApp::new, (Object)appId);
        return tree.fetch(appId, type, leaf);
    }

    @Override
    public Future<JsonArray> treeApp(String appId, JsonArray types) {
        Tree tree = (Tree)CC_TREE.pick(TreeApp::new, (Object)appId);
        return tree.fetch(appId, types);
    }

    @Override
    public Future<JsonObject> treeApp(String appId, String type, String code) {
        Tree tree = (Tree)CC_TREE.pick(TreeApp::new, (Object)appId);
        return tree.fetch(appId, type, code);
    }

    @Override
    public Future<JsonArray> treeSigma(String sigma, String type, Boolean leaf) {
        Tree tree = (Tree)CC_TREE.pick(TreeSigma::new, (Object)sigma);
        return tree.fetch(sigma, type, leaf);
    }

    @Override
    public Future<JsonArray> treeSigma(String sigma, JsonArray types) {
        Tree tree = (Tree)CC_TREE.pick(TreeSigma::new, (Object)sigma);
        return tree.fetch(sigma, types);
    }

    @Override
    public Future<JsonObject> treeSigma(String sigma, String type, String code) {
        Tree tree = (Tree)CC_TREE.pick(TreeSigma::new, (Object)sigma);
        return tree.fetch(sigma, type, code);
    }

    @Override
    public Future<JsonArray> numberApp(String appId, String code, Integer count) {
        At.LOG.Flow.info(this.getClass(), "Serial Gen: appId = {0}, code = {1}, count = {2}", new Object[]{appId, code, count});
        JsonObject condition = new JsonObject();
        condition.put("appId", (Object)appId).put("code", (Object)code);
        Serial serial = (Serial)CC_SERIAL.pick(SerialGen::new, (Object)appId);
        return serial.generate(condition, count);
    }

    @Override
    public Future<JsonArray> numberAppI(String appId, String identifier, Integer count) {
        At.LOG.Flow.info(this.getClass(), "Serial Gen: appId = {0}, identifier = {1}, count = {2}", new Object[]{appId, identifier, count});
        JsonObject condition = new JsonObject();
        condition.put("appId", (Object)appId).put("identifier", (Object)identifier);
        Serial serial = (Serial)CC_SERIAL.pick(SerialGen::new, (Object)appId);
        return serial.generate(condition, count);
    }

    @Override
    public Future<JsonArray> numberSigma(String sigma, String code, Integer count) {
        At.LOG.Flow.info(this.getClass(), "Serial Gen: sigma = {0}, code = {1}, count = {2}", new Object[]{sigma, code, count});
        JsonObject condition = new JsonObject();
        condition.put("sigma", (Object)sigma).put("code", (Object)code);
        Serial serial = (Serial)CC_SERIAL.pick(SerialGen::new, (Object)sigma);
        return serial.generate(condition, count);
    }

    @Override
    public Future<JsonArray> numberSigmaI(String sigma, String identifier, Integer count) {
        At.LOG.Flow.info(this.getClass(), "Serial Gen: sigma = {0}, identifier = {1}, count = {2}", new Object[]{sigma, identifier, count});
        JsonObject condition = new JsonObject();
        condition.put("sigma", (Object)sigma).put("identifier", (Object)identifier);
        Serial serial = (Serial)CC_SERIAL.pick(SerialGen::new, (Object)sigma);
        return serial.generate(condition, count);
    }

    @Override
    public Future<Boolean> numberAppR(String appId, String code, Long defaultValue) {
        At.LOG.Flow.info(this.getClass(), "Serial Reset: appId = {0}, code = {1}, default = {2}", new Object[]{appId, code, String.valueOf(defaultValue)});
        JsonObject condition = new JsonObject();
        condition.put("appId", (Object)appId).put("code", (Object)code);
        Serial serial = (Serial)CC_SERIAL.pick(SerialGen::new, (Object)appId);
        return serial.reset(condition, defaultValue);
    }

    @Override
    public Future<Boolean> numberSigmaR(String sigma, String code, Long defaultValue) {
        At.LOG.Flow.info(this.getClass(), "Serial Reset: sigma = {0}, code = {1}, default = {2}", new Object[]{sigma, code, String.valueOf(defaultValue)});
        JsonObject condition = new JsonObject();
        condition.put("sigma", (Object)sigma).put("code", (Object)code);
        Serial serial = (Serial)CC_SERIAL.pick(SerialGen::new, (Object)sigma);
        return serial.reset(condition, defaultValue);
    }
}

