/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.ambient.service;

import cn.vertxup.ambient.domain.tables.daos.XModuleDao;
import cn.vertxup.ambient.service.ModelStub;
import io.horizon.spi.environment.Modeling;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.fn.Fn;
import io.vertx.up.uca.log.DevEnv;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;

public class ModelService
implements ModelStub {
    private static final ConcurrentMap<String, JsonObject> CACHE_MODULE = new ConcurrentHashMap<String, JsonObject>();

    @Override
    public Future<JsonObject> fetchModule(String appId, String entry) {
        JsonObject filters = new JsonObject().put("", (Object)Boolean.TRUE).put("entry", (Object)entry).put("appId", (Object)appId);
        return this.fetchModule(filters, () -> Ux.Jooq.on(XModuleDao.class).fetchOneAsync(filters).compose(Ux::futureJ).compose(Fn.ofJObject((String[])new String[]{"metadata"})));
    }

    @Override
    public Future<JsonArray> fetchModels(String sigma) {
        return Ux.channel(Modeling.class, JsonArray::new, model -> model.fetchAsync(sigma));
    }

    @Override
    public Future<JsonArray> fetchAttrs(String identifier, String sigma) {
        return Ux.channel(Modeling.class, JsonArray::new, model -> model.fetchAttrs(identifier, sigma));
    }

    private Future<JsonObject> fetchModule(JsonObject condition, Supplier<Future<JsonObject>> executor) {
        String appId = condition.getString("appId");
        String entry = condition.getString("entry");
        if (Ut.isNil((String[])new String[]{appId, entry})) {
            return Ux.futureJ();
        }
        String cacheKey = appId + ":" + entry;
        if (DevEnv.cacheUi()) {
            JsonObject cachedData = CACHE_MODULE.getOrDefault(cacheKey, null);
            if (Objects.isNull(cachedData)) {
                return executor.get().compose(dataData -> {
                    if (Objects.nonNull(dataData)) {
                        CACHE_MODULE.put(cacheKey, (JsonObject)dataData);
                    }
                    return Ux.future((Object)dataData);
                });
            }
            return Ux.future((Object)cachedData);
        }
        return executor.get();
    }
}

