/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.ambient.service.application;

import cn.vertxup.ambient.domain.tables.daos.XAppDao;
import cn.vertxup.ambient.domain.tables.daos.XSourceDao;
import cn.vertxup.ambient.service.application.AppStub;
import io.horizon.spi.business.ExApp;
import io.horizon.spi.feature.Attachment;
import io.horizon.spi.modeler.Modulat;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ambient.refine.At;
import io.vertx.up.atom.unity.UObject;
import io.vertx.up.fn.Fn;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;

public class AppService
implements AppStub {
    @Override
    public Future<JsonObject> fetchByName(String name) {
        return Ux.Jooq.on(XAppDao.class).fetchOneAsync("name", (Object)name).compose(Ux::futureJ).compose(appData -> UObject.create((JsonObject)appData).remove(new String[]{"appKey"}).toFuture()).compose(At::fileMeta);
    }

    @Override
    public Future<JsonObject> fetchById(String appId) {
        return Ux.Jooq.on(XAppDao.class).fetchByIdAsync((Object)appId).compose(Ux::futureJ).compose(At::fileMeta).compose(appJ -> Ux.channel(ExApp.class, () -> appJ, stub -> stub.fetchOpts(appJ))).compose(appJ -> Ux.channel(Modulat.class, () -> appJ, stub -> stub.extension(appJ)));
    }

    @Override
    public Future<JsonObject> fetchSource(String appId) {
        return Ux.Jooq.on(XSourceDao.class).fetchOneAsync("appId", (Object)appId).compose(Ux::futureJ).compose(Fn.ofJObject((String[])new String[]{"jdbcConfig"}));
    }

    @Override
    public Future<JsonObject> updateBy(String appId, JsonObject data) {
        return this.updateLogo(appId, data).compose(updated -> Ux.Jooq.on(XAppDao.class).updateJAsync((Object)appId, updated).compose(Fn.ofJObject((String[])new String[]{"logo"})));
    }

    private Future<JsonObject> updateLogo(String appId, JsonObject data) {
        JsonArray attachment = data.getJsonArray("logo", new JsonArray());
        Ut.itJArray((JsonArray)attachment).forEach(each -> each.put("modelKey", (Object)appId));
        JsonObject condition = new JsonObject();
        condition.put("modelId", (Object)"x.application");
        condition.put("modelCategory", (Object)"logo");
        condition.put("modelKey", (Object)appId);
        condition.put("", (Object)Boolean.TRUE);
        return Ux.channel(Attachment.class, () -> data, file -> file.saveAsync(condition, attachment).compose(saved -> {
            data.put("logo", (Object)saved.encode());
            return Ux.future((Object)data);
        }));
    }
}

