/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.ambient.service.application;

import cn.vertxup.ambient.domain.tables.daos.XAppDao;
import cn.vertxup.ambient.service.application.AppStub;
import cn.vertxup.ambient.service.application.InitStub;
import io.horizon.spi.extension.Init;
import io.horizon.spi.extension.Prerequisite;
import io.horizon.uca.log.Annal;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ambient.init.AtPin;
import io.vertx.tp.ambient.refine.At;
import io.vertx.up.atom.unity.UObject;
import io.vertx.up.fn.Fn;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Objects;
import javax.inject.Inject;

public class InitService
implements InitStub {
    private static final Annal LOGGER = Annal.get(InitService.class);
    @Inject
    private transient AppStub stub;

    @Override
    public Future<JsonObject> initCreation(String appId, JsonObject data) {
        return Ux.future((Object)data.put("key", (Object)appId)).compose(At.initApp().apply()).compose(At.initSource().apply()).compose(At.initDatabase().apply()).compose(this::initDefined).compose(At.initData().apply()).compose(Fn.ofJObject((String[])new String[]{"logo"}));
    }

    @Override
    public Future<JsonObject> initEdition(String appName) {
        return this.initModeling(appName).compose(At.initData().apply());
    }

    @Override
    public Future<JsonObject> prerequisite(String appName) {
        Prerequisite prerequisite = AtPin.getPrerequisite();
        if (Objects.isNull(prerequisite)) {
            At.LOG.Init.info(LOGGER, "`Prerequisite` configuration is null", new Object[0]);
            return Ux.future((Object)new JsonObject());
        }
        return prerequisite.prepare(appName);
    }

    @Override
    public Future<JsonObject> initModeling(String appName) {
        return this.initModeling(appName, null);
    }

    @Override
    public Future<JsonObject> initModeling(String appName, String outPath) {
        return Ux.Jooq.on(XAppDao.class).fetchOneAsync("name", (Object)appName).compose(Ux::futureJ).compose(this::initCombine).compose(appJson -> this.initOutput((JsonObject)appJson, outPath)).compose(this::initDefined).compose(Fn.ofJObject((String[])new String[]{"logo"}));
    }

    private Future<JsonObject> initOutput(JsonObject combined, String outPath) {
        if (Ut.isNotNil((String)outPath)) {
            combined.put("output", (Object)outPath);
        }
        return Ux.future((Object)combined);
    }

    private Future<JsonObject> initCombine(JsonObject appJson) {
        return this.stub.fetchSource(appJson.getString("key")).compose(source -> UObject.create((JsonObject)appJson).append("source", source).toFuture());
    }

    private Future<JsonObject> initDefined(JsonObject input) {
        Init initializer = AtPin.getInit();
        if (Objects.isNull(initializer)) {
            At.LOG.Init.info(LOGGER, "`Init` configuration is null", new Object[0]);
            return Ux.future((Object)input);
        }
        return (Future)initializer.apply().apply(input);
    }
}

