/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.ambient.service.file;

import cn.vertxup.ambient.domain.tables.daos.XCategoryDao;
import cn.vertxup.ambient.service.file.DocBStub;
import cn.vertxup.ambient.service.file.DocReader;
import io.horizon.spi.feature.Arbor;
import io.horizon.uca.cache.Cc;
import io.horizon.uca.log.Annal;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ambient.atom.AtConfig;
import io.vertx.tp.ambient.init.AtPin;
import io.vertx.tp.ambient.refine.At;
import io.vertx.up.fn.Fn;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.ArrayList;
import java.util.Objects;

public class DocBuilder
implements DocBStub {
    private static final Cc<String, Arbor> CC_ARBOR = Cc.openThread();
    private static final Annal LOGGER = Annal.get(DocReader.class);

    @Override
    public Future<JsonArray> initialize(String appId, String type) {
        JsonObject condition = this.qrCond(appId, type, null);
        return Ux.Jooq.on(XCategoryDao.class).fetchJAsync(condition).compose(Fn.ofJArray((String[])new String[]{"metadata", "treeConfig", "runConfig"})).compose(categories -> {
            ArrayList futures = new ArrayList();
            Ut.itJArray((JsonArray)categories).map(this::seekAsync).forEach(futures::add);
            return Fn.compressA(futures);
        });
    }

    @Override
    public Future<JsonArray> initialize(String appId, String type, String name) {
        JsonObject condition = this.qrCond(appId, type, name);
        return Ux.Jooq.on(XCategoryDao.class).fetchJOneAsync(condition).compose(Fn.ofJObject((String[])new String[]{"metadata", "treeConfig", "runConfig"})).compose(this::seekAsync);
    }

    private JsonObject qrCond(String appId, String type, String name) {
        JsonObject condition = Ux.whereAnd();
        condition.put("appId", (Object)appId);
        condition.put("type", (Object)type);
        condition.put("active", (Object)Boolean.TRUE);
        if (Ut.isNotNil((String)name)) {
            condition.put("name", (Object)name);
        }
        return condition;
    }

    private Future<JsonArray> seekAsync(JsonObject input) {
        String runComponent = input.getString("treeComponent");
        Class arborCls = Ut.clazz((String)runComponent, null);
        if (Objects.isNull(arborCls) || !Ut.isImplement((Class)arborCls, Arbor.class)) {
            return Ux.futureA();
        }
        JsonObject configuration = input.getJsonObject("treeConfig");
        JsonObject storeRef = configuration.getJsonObject("store");
        if (Ut.isNil((JsonObject)storeRef)) {
            storeRef = new JsonObject();
        }
        AtConfig config = AtPin.getConfig();
        storeRef.put("storePath", (Object)config.getStorePath());
        configuration.put("store", (Object)storeRef);
        Arbor arbor = (Arbor)CC_ARBOR.pick(() -> (Arbor)Ut.instance((Class)arborCls, (Object[])new Object[0]), (Object)arborCls.getName());
        At.LOG.File.info(LOGGER, "Arbor = {0}, Configuration = {1}", new Object[]{arborCls.getName(), configuration.encode()});
        return arbor.generate(input, configuration);
    }
}

