/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.ambient.service.file;

import cn.vertxup.ambient.service.DatumStub;
import cn.vertxup.ambient.service.file.DocRStub;
import io.horizon.spi.business.ExIo;
import io.horizon.spi.business.ExUser;
import io.horizon.spi.feature.Arbor;
import io.horizon.spi.feature.Attachment;
import io.horizon.uca.cache.Cc;
import io.horizon.uca.log.Annal;
import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;

public class DocReader
implements DocRStub {
    private static final Cc<String, Arbor> CC_ARBOR = Cc.openThread();
    private static final Annal LOGGER = Annal.get(DocReader.class);
    @Inject
    private transient DatumStub stub;
    @Inject
    private transient Attachment attachment;

    @Override
    public Future<JsonArray> fetchDoc(String sigma, String directoryId) {
        Objects.requireNonNull(sigma);
        return Ux.channel(ExIo.class, JsonArray::new, io -> io.dirRun(sigma, directoryId)).compose(directory -> {
            JsonObject condition = Ux.whereAnd();
            condition.put("directoryId", (Object)directoryId);
            condition.put("active", (Object)Boolean.TRUE);
            condition.put("sigma", (Object)sigma);
            return this.attachment.fetchAsync(condition).compose(files -> {
                directory.addAll(files);
                return Ux.future((Object)directory);
            });
        });
    }

    @Override
    public Future<JsonArray> fetchTrash(String sigma) {
        Objects.requireNonNull(sigma);
        return Ux.channel(ExIo.class, JsonArray::new, io -> io.dirTrash(sigma)).compose(directory -> {
            JsonObject condition = Ux.whereAnd();
            condition.put("active", (Object)Boolean.FALSE);
            condition.put("sigma", (Object)sigma);
            return this.attachment.fetchAsync(condition).compose(files -> {
                directory.addAll(files);
                return Ux.future((Object)directory);
            });
        });
    }

    @Override
    public Future<JsonArray> searchDoc(String sigma, String keyword) {
        Objects.requireNonNull(sigma);
        JsonObject condition = Ux.whereAnd();
        condition.put("sigma", (Object)sigma);
        condition.put("active", (Object)Boolean.TRUE);
        return Ux.channel(ExUser.class, JsonArray::new, user -> user.searchUser(keyword)).compose(keys -> {
            if (Ut.isNotNil((JsonArray)keys)) {
                JsonObject criteria = Ux.whereOr();
                criteria.put("name,c", (Object)keyword);
                criteria.put("createdBy,i", keys);
                condition.put("$Qr$", (Object)criteria);
            } else {
                condition.put("name,c", (Object)keyword);
            }
            return this.attachment.fetchAsync(condition);
        });
    }

    @Override
    public Future<Buffer> downloadDoc(String key) {
        return this.attachment.downloadAsync(key);
    }

    @Override
    public Future<Buffer> downloadDoc(Set<String> keys) {
        return this.attachment.downloadAsync(keys);
    }
}

