/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.ambient.service.file;

import cn.vertxup.ambient.domain.tables.daos.XAttachmentDao;
import cn.vertxup.ambient.domain.tables.pojos.XAttachment;
import cn.vertxup.ambient.service.file.DocWStub;
import io.horizon.atom.common.Kv;
import io.horizon.spi.business.ExIo;
import io.horizon.spi.feature.Attachment;
import io.horizon.uca.log.Annal;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ambient.refine.At;
import io.vertx.tp.error._400FileNameInValidException;
import io.vertx.up.fn.Fn;
import io.vertx.up.uca.jooq.UxJooq;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.inject.Inject;

public class DocWriter
implements DocWStub {
    private static final Annal LOGGER = Annal.get(DocWriter.class);
    @Inject
    private transient Attachment attachment;

    @Override
    public Future<JsonArray> upload(JsonArray documentA) {
        return Ux.channel(Attachment.class, () -> documentA, file -> file.uploadAsync(documentA));
    }

    @Override
    public Future<JsonObject> rename(JsonObject documentJ) {
        String name = documentJ.getString("name");
        if (!Ut.isFileName((String)name)) {
            return Fn.outWeb(_400FileNameInValidException.class, (Object[])new Object[]{this.getClass()});
        }
        String key = documentJ.getString("key");
        UxJooq jq = Ux.Jooq.on(XAttachmentDao.class);
        return jq.fetchByIdAsync((Object)key).compose(attachment -> {
            String from = attachment.getStorePath();
            JsonObject documentData = documentJ.copy();
            Ut.valueToString((JsonObject)documentData, (String[])new String[]{"metadata", "visitMode"});
            XAttachment updated = (XAttachment)Ux.updateT((Object)attachment, (JsonObject)documentData);
            return jq.updateAsync((Object)updated).compose(processed -> {
                String to = processed.getStorePath();
                return Ux.future((Object)Kv.create((Object)from, (Object)to));
            }).compose(kv -> {
                String directoryId = attachment.getDirectoryId();
                JsonObject directoryJ = new JsonObject();
                directoryJ.put("key", (Object)directoryId);
                directoryJ.put("updatedBy", (Object)documentJ.getString("updatedBy"));
                return Ux.channel(ExIo.class, () -> documentJ, io -> io.rename(directoryJ, kv).compose(nil -> Ux.future((Object)documentJ)));
            });
        });
    }

    @Override
    public Future<JsonArray> trashIn(JsonArray documentA) {
        return this.trashSplit(documentA, attachmentA -> this.attachment.updateAsync(attachmentA, Boolean.FALSE.booleanValue()), (directoryA, attachmentA) -> {
            ConcurrentMap fileMap = Ut.elementMap((JsonArray)attachmentA, (String)"storePath", (String)"directoryId");
            return Ux.channel(ExIo.class, () -> documentA, fs -> fs.trashIn(directoryA, fileMap));
        });
    }

    @Override
    public Future<JsonArray> trashOut(JsonArray documentA) {
        return this.trashSplit(documentA, attachmentA -> this.attachment.updateAsync(attachmentA, Boolean.TRUE.booleanValue()), (directoryA, attachmentA) -> {
            ConcurrentMap fileMap = Ut.elementMap((JsonArray)attachmentA, (String)"storePath", (String)"directoryId");
            return Ux.channel(ExIo.class, () -> documentA, fs -> fs.trashOut(directoryA, fileMap));
        });
    }

    @Override
    public Future<JsonArray> trashKo(JsonArray documentA) {
        return this.trashSplit(documentA, arg_0 -> ((Attachment)this.attachment).purgeAsync(arg_0), (directoryA, attachmentA) -> {
            ConcurrentMap fileMap = Ut.elementMap((JsonArray)attachmentA, (String)"storePath", (String)"directoryId");
            return Ux.channel(ExIo.class, () -> documentA, fs -> fs.purge(directoryA, fileMap).compose(this::trashKoDeep));
        });
    }

    private Future<JsonArray> trashKoDeep(JsonArray directory) {
        JsonObject children = Ux.whereOr();
        Ut.itJArray((JsonArray)directory).forEach(json -> {
            String storePath = json.getString("storePath");
            if (Ut.isNotNil((String)storePath)) {
                JsonObject child = Ux.whereAnd();
                child.put("storePath,s", (Object)json.getString("storePath"));
                child.put("active", (Object)Boolean.FALSE);
                children.put("$" + json.getString("code") + "$", (Object)child);
            }
        });
        return Ux.Jooq.on(XAttachmentDao.class).deleteByAsync(children).compose(nil -> Ux.future((Object)directory));
    }

    private Future<JsonArray> trashSplit(JsonArray source, Function<JsonArray, Future<JsonArray>> fnAttachment, BiFunction<JsonArray, JsonArray, Future<JsonArray>> fnDirectory) {
        JsonArray attachmentJ = new JsonArray();
        JsonArray directoryJ = new JsonArray();
        Ut.itJArray((JsonArray)source).forEach(item -> {
            Boolean directory = item.getBoolean("directory", Boolean.FALSE);
            if (directory.booleanValue()) {
                directoryJ.add(item);
            } else {
                attachmentJ.add(item);
            }
        });
        At.LOG.File.info(LOGGER, "Split Running: Document = {0}, Directory = {1}", new Object[]{attachmentJ.size(), directoryJ.size()});
        if (Ut.isNotNil((JsonArray)directoryJ)) {
            return Ux.future((Object)attachmentJ).compose(fnAttachment).compose(processed -> ((Future)fnDirectory.apply(directoryJ, (JsonArray)processed)).compose(directory -> {
                JsonArray documents = new JsonArray();
                documents.addAll(processed);
                documents.addAll(directory);
                return Ux.future((Object)documents);
            }));
        }
        return Ux.future((Object)attachmentJ).compose(fnAttachment);
    }
}

