/*
 * Decompiled with CFR 0.152.
 */
package io.horizon.spi.business;

import cn.vertxup.ambient.domain.tables.daos.XActivityChangeDao;
import cn.vertxup.ambient.domain.tables.daos.XActivityDao;
import cn.vertxup.ambient.domain.tables.pojos.XActivity;
import io.horizon.spi.business.ExActivity;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.fn.Fn;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class ExActivityTracker
implements ExActivity {
    public Future<JsonArray> activities(String modelId, String modelKey) {
        return this.fetchActivities(modelId, modelKey).compose(Ux::futureA).compose(Fn.ofJArray((String[])new String[]{"recordNew", "recordOld"}));
    }

    public Future<JsonArray> activities(JsonObject condition) {
        return Ux.Jooq.on(XActivityDao.class).fetchAsync(condition).compose(Ux::futureA);
    }

    public Future<JsonObject> activity(String activityId) {
        return Ux.Jooq.on(XActivityDao.class).fetchByIdAsync((Object)activityId).compose(activity -> {
            if (Objects.isNull(activity)) {
                return Ux.futureJ();
            }
            return this.changes(activityId).compose(changes -> {
                JsonObject activityJ = Ux.toJson((Object)activity);
                Ut.valueToJObject((JsonObject)activityJ, (String[])new String[]{"recordNew", "recordOld"});
                activityJ.put("changes", changes);
                return Ux.future((Object)activityJ);
            });
        });
    }

    private Future<List<XActivity>> fetchActivities(String modelId, String modelKey) {
        JsonObject criteria = new JsonObject();
        criteria.put("modelId", (Object)modelId);
        criteria.put("modelKey", (Object)modelKey);
        criteria.put("active", (Object)Boolean.TRUE);
        return Ux.Jooq.on(XActivityDao.class).fetchAndAsync(criteria);
    }

    public Future<JsonArray> changes(String modelId, String modelKey, String field) {
        Objects.requireNonNull(field);
        return this.fetchActivities(modelId, modelKey).compose(activities -> {
            Set activityIds = activities.stream().map(XActivity::getKey).collect(Collectors.toSet());
            JsonObject criteria = new JsonObject();
            criteria.put("activityId,i", (Object)Ut.toJArray(activityIds));
            criteria.put("fieldName", (Object)field);
            return Ux.Jooq.on(XActivityChangeDao.class).fetchAndAsync(criteria).compose(Ux::futureA);
        });
    }

    public Future<JsonArray> changes(String activityId) {
        return Ux.Jooq.on(XActivityChangeDao.class).fetchAsync("activityId", (Object)activityId).compose(Ux::futureA);
    }
}

