/*
 * Decompiled with CFR 0.152.
 */
package io.horizon.spi.component;

import cn.vertxup.ambient.service.DatumService;
import cn.vertxup.ambient.service.DatumStub;
import io.horizon.eon.em.uca.DictType;
import io.horizon.spi.component.Dictionary;
import io.horizon.uca.cache.Cc;
import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.json.JsonArray;
import io.vertx.tp.ambient.refine.At;
import io.vertx.tp.ambient.uca.dict.Dpm;
import io.vertx.up.commune.exchange.DSource;
import io.vertx.up.fn.Fn;
import io.vertx.up.unity.Ux;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ExAmbientDictionary
implements Dictionary {
    private static final Cc<String, DatumStub> CC_DICT = Cc.openThread();

    public Future<ConcurrentMap<String, JsonArray>> fetchAsync(MultiMap paramMap, List<DSource> sources) {
        if (Objects.isNull(sources) || sources.isEmpty()) {
            return Ux.future(new ConcurrentHashMap());
        }
        ArrayList futures = new ArrayList();
        sources.forEach(source -> {
            DictType type = source.getSourceType();
            Dpm dpm = Dpm.get(type);
            if (Objects.nonNull(dpm)) {
                futures.add(dpm.fetchAsync((DSource)source, paramMap));
            }
        });
        return Fn.compressM(futures).compose(dict -> {
            StringBuilder report = new StringBuilder();
            report.append("[ PT ] Dictionary Total\uff1a").append(dict.size());
            dict.forEach((key, array) -> report.append("\n\tkey = ").append((String)key).append(", value size = ").append(array.size()));
            At.LOG.Flow.info(this.getClass(), report.toString(), new Object[0]);
            return Ux.future((Object)dict);
        });
    }

    public Future<JsonArray> fetchTree(String sigma, String type) {
        DatumStub stub = (DatumStub)CC_DICT.pick(DatumService::new);
        return stub.treeSigma(sigma, type);
    }

    public Future<JsonArray> fetchList(String sigma, String type) {
        DatumStub stub = (DatumStub)CC_DICT.pick(DatumService::new);
        return stub.dictSigma(sigma, type);
    }
}

