/*
 * Decompiled with CFR 0.152.
 */
package io.horizon.spi.environment;

import cn.vertxup.ambient.domain.tables.pojos.XApp;
import cn.vertxup.ambient.domain.tables.pojos.XSource;
import io.aeon.runtime.CRunning;
import io.horizon.spi.environment.UnityApp;
import io.horizon.spi.environment.UnityAsker;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.up.fn.Fn;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;

public class UnityAmbient
implements UnityApp {
    public Future<JsonObject> synchro(String appId) {
        ConcurrentMap stored = CRunning.CC_META_APP.store();
        return UnityAsker.synchro(appId).compose(nil -> {
            ConcurrentMap<String, XApp> apps = UnityAsker.getApps();
            ConcurrentMap<String, XSource> sources = UnityAsker.getSources();
            XApp app = (XApp)apps.get(appId);
            XSource source = (XSource)sources.get(appId);
            JsonObject updated = this.connect(app, source);
            stored.put(appId, updated);
            return Future.succeededFuture((Object)updated);
        });
    }

    public Future<Boolean> initialize(Vertx vertx) {
        ConcurrentMap stored = CRunning.CC_META_APP.store();
        if (!stored.isEmpty()) {
            return Ux.futureT();
        }
        return UnityAsker.init(vertx).compose(nil -> {
            ConcurrentMap<String, XApp> apps = UnityAsker.getApps();
            ConcurrentMap<String, XSource> sources = UnityAsker.getSources();
            apps.keySet().stream().map(appId -> this.connect((XApp)apps.get(appId), (XSource)sources.get(appId))).forEach(item -> stored.put(item.getString("appId"), item));
            return Future.succeededFuture((Object)Boolean.TRUE);
        });
    }

    public ConcurrentMap<String, JsonObject> connect() {
        return CRunning.CC_META_APP.store();
    }

    private JsonObject connect(XApp app, XSource source) {
        JsonObject normalized = new JsonObject();
        normalized.put("key", (Object)app.getKey());
        normalized.put("appId", (Object)app.getKey());
        normalized.put("appKey", (Object)app.getAppKey());
        normalized.put("sigma", (Object)app.getSigma());
        normalized.put("name", (Object)app.getName());
        normalized.put("code", (Object)app.getCode());
        normalized.put("language", (Object)app.getLanguage());
        normalized.put("active", (Object)app.getActive());
        normalized.put("logo", (Object)app.getLogo());
        normalized.put("title", (Object)app.getTitle());
        JsonObject business = new JsonObject();
        business.put("icp", (Object)app.getIcp());
        business.put("email", (Object)app.getEmail());
        business.put("copyRight", (Object)app.getCopyRight());
        normalized.put("business", (Object)business);
        JsonObject backend = new JsonObject();
        backend.put("domain", (Object)app.getDomain());
        backend.put("appPort", (Object)app.getAppPort());
        backend.put("route", (Object)app.getRoute());
        normalized.put("backend", (Object)backend);
        JsonObject frontend = new JsonObject();
        frontend.put("path", (Object)app.getPath());
        frontend.put("urlEntry", (Object)app.getUrlEntry());
        frontend.put("urlMain", (Object)app.getUrlMain());
        normalized.put("frontend", (Object)frontend);
        JsonObject auditor = new JsonObject();
        auditor.put("createdBy", (Object)app.getCreatedBy());
        Fn.runAt(() -> auditor.put("createdAt", (Object)Ut.parse((LocalDateTime)app.getCreatedAt()).toInstant()), (Object[])new Object[]{app.getCreatedAt()});
        auditor.put("updatedBy", (Object)app.getUpdatedBy());
        Fn.runAt(() -> auditor.put("updatedAt", (Object)Ut.parse((LocalDateTime)app.getUpdatedAt()).toInstant()), (Object[])new Object[]{app.getUpdatedAt()});
        normalized.put("auditor", (Object)auditor);
        if (Objects.nonNull(source)) {
            JsonObject sourceJson = new JsonObject();
            sourceJson.put("hostname", (Object)source.getHostname());
            sourceJson.put("instance", (Object)source.getInstance());
            sourceJson.put("port", (Object)source.getPort());
            sourceJson.put("category", (Object)source.getCategory());
            sourceJson.put("jdbcUrl", (Object)source.getJdbcUrl());
            sourceJson.put("username", (Object)source.getUsername());
            sourceJson.put("password", (Object)source.getPassword());
            sourceJson.put("driverClassName", (Object)source.getDriverClassName());
            String jdbcConfig = source.getJdbcConfig();
            if (Ut.isNotNil((String)jdbcConfig)) {
                sourceJson.put("options", (Object)Ut.toJObject((String)jdbcConfig));
            }
            normalized.put("source", (Object)sourceJson);
        }
        return normalized;
    }
}

