/*
 * Decompiled with CFR 0.152.
 */
package io.horizon.spi.environment;

import cn.vertxup.ambient.domain.tables.daos.XAppDao;
import cn.vertxup.ambient.domain.tables.daos.XSourceDao;
import cn.vertxup.ambient.domain.tables.pojos.XApp;
import cn.vertxup.ambient.domain.tables.pojos.XSource;
import io.horizon.uca.log.Annal;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.tp.ambient.refine.At;
import io.vertx.tp.ke.refine.Ke;
import io.vertx.up.atom.Refer;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jooq.Configuration;

class UnityAsker {
    private static final Annal LOGGER = Annal.get(UnityAsker.class);
    private static final ConcurrentMap<String, XApp> APP_POOL = new ConcurrentHashMap<String, XApp>();
    private static final ConcurrentMap<String, XSource> SOURCE_POOL = new ConcurrentHashMap<String, XSource>();

    UnityAsker() {
    }

    static Future<Boolean> init(Vertx vertx) {
        Configuration configuration = Ke.getConfiguration();
        XAppDao appDao = new XAppDao(configuration, vertx);
        return ((Future)appDao.findAll()).compose(applications -> {
            At.LOG.App.info(LOGGER, "{0} Application have been initialized successfully!", new Object[]{applications.size()});
            APP_POOL.putAll(Ut.elementZip((Collection)applications, XApp::getKey, app -> app));
            return Future.succeededFuture((Object)Boolean.TRUE);
        }).compose(nil -> {
            XSourceDao sourceDao = new XSourceDao(configuration, vertx);
            return (Future)sourceDao.findAll();
        }).compose(sources -> {
            At.LOG.App.info(LOGGER, "{0} Data source have been initialized successfully!", new Object[]{sources.size()});
            SOURCE_POOL.putAll(Ut.elementZip((Collection)sources, XSource::getAppId, source -> source));
            return Future.succeededFuture((Object)Boolean.TRUE);
        });
    }

    static Future<Boolean> synchro(String appId) {
        Refer refer = new Refer();
        return Ux.Jooq.on(XAppDao.class).fetchByIdAsync((Object)appId).compose(app -> {
            Objects.requireNonNull(app);
            refer.add((Object)app.getName());
            At.LOG.App.info(LOGGER, "Application ( name = {0} ) has been synced successfully!", (Object[])refer.get());
            APP_POOL.put(appId, (XApp)app);
            return Ux.future((Object)app);
        }).compose(app -> Ux.Jooq.on(XSourceDao.class).fetchByIdAsync((Object)app.getKey())).compose(source -> {
            if (Objects.nonNull(source)) {
                At.LOG.App.info(LOGGER, "Data Source ( name = {0} ) has been synced successfully!", (Object[])refer.get());
                SOURCE_POOL.put(appId, (XSource)source);
            }
            return Ux.futureT();
        });
    }

    static ConcurrentMap<String, XApp> getApps() {
        return APP_POOL;
    }

    static ConcurrentMap<String, XSource> getSources() {
        return SOURCE_POOL;
    }
}

