/*
 * Decompiled with CFR 0.152.
 */
package io.horizon.spi.extension;

import io.horizon.spi.extension.Init;
import io.horizon.uca.log.Annal;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ambient.atom.AtConfig;
import io.vertx.tp.ambient.init.AtPin;
import io.vertx.tp.ambient.refine.At;
import io.vertx.tp.plugin.excel.ExcelClient;
import io.vertx.tp.plugin.excel.ExcelInfix;
import io.vertx.up.atom.unity.UObject;
import io.vertx.up.fn.Fn;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public class DatumInit
implements Init {
    private static final Annal LOGGER = Annal.get(DatumInit.class);
    private static final AtConfig CONFIG = AtPin.getConfig();

    public Function<JsonObject, Future<JsonObject>> apply() {
        return appJson -> {
            At.LOG.App.info(LOGGER, "Data Loading: {0}", new Object[]{appJson.encode()});
            return this.doLoading((JsonObject)appJson).compose(this::doExtension);
        };
    }

    public Future<JsonObject> doExtension(JsonObject appJson) {
        Init loader = AtPin.getLoader();
        if (Objects.isNull(loader)) {
            return Ux.future((Object)appJson);
        }
        return (Future)loader.apply().apply(appJson);
    }

    private Future<JsonObject> doLoading(JsonObject appJson) {
        String dataFolder = CONFIG.getDataFolder();
        List files = Ut.ioFiles((String)dataFolder);
        List futures = files.stream().filter(x$0 -> Ut.isNotNil((String)x$0)).filter(file -> !file.startsWith("~$")).map(file -> dataFolder + file).map(this::doLoading).collect(Collectors.toList());
        return Fn.combineA(futures).compose(results -> UObject.create().append("result", results).toFuture()).compose(results -> Ux.future((Object)this.result((JsonObject)results, appJson)));
    }

    private Future<JsonObject> doLoading(String filename) {
        return Ux.nativeWorker((String)filename, pre -> {
            ExcelClient client = ExcelInfix.createClient();
            client.importAsync(filename, result -> {
                At.LOG.App.info(LOGGER, "Data Loading: filename = {0}", new Object[]{filename});
                if (result.succeeded()) {
                    pre.complete((Object)Ut.endBool((boolean)Boolean.TRUE, (String)filename));
                } else {
                    pre.fail(result.cause());
                }
            });
        });
    }

    public JsonObject result(JsonObject input, JsonObject appJson) {
        return appJson;
    }
}

