/*
 * Decompiled with CFR 0.152.
 */
package io.horizon.spi.feature;

import cn.vertxup.ambient.domain.tables.daos.XAttachmentDao;
import cn.vertxup.ambient.domain.tables.pojos.XAttachment;
import io.horizon.eon.em.typed.ChangeFlag;
import io.horizon.spi.business.ExIo;
import io.horizon.spi.feature.Attachment;
import io.horizon.uca.log.Annal;
import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ambient.refine.At;
import io.vertx.up.fn.Fn;
import io.vertx.up.uca.jooq.UxJooq;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.time.Instant;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

public class ExAttachment
implements Attachment {
    private static final Annal LOGGER = Annal.get(ExAttachment.class);

    public Future<JsonArray> saveAsync(JsonObject condition, JsonArray data) {
        if (Ut.isNil((JsonArray)data)) {
            return Ux.futureA();
        }
        JsonObject params = this.uploadParams(data);
        return this.saveAsync(condition, data, params);
    }

    public Future<JsonArray> saveAsync(JsonObject condition, JsonArray data, JsonObject params) {
        UxJooq jq = Ux.Jooq.on(XAttachmentDao.class);
        return jq.fetchJAsync(condition).compose(original -> {
            ConcurrentMap compared = Ux.compareJ((JsonArray)original, (JsonArray)data, (String)"key");
            JsonArray deleted = compared.getOrDefault(ChangeFlag.DELETE, new JsonArray());
            return jq.deleteJAsync(deleted).compose(nil -> At.fileRemove(deleted)).compose(nil -> {
                JsonArray added = compared.getOrDefault(ChangeFlag.ADD, new JsonArray());
                return this.uploadAsync(added, params);
            }).compose(added -> {
                JsonArray combine = compared.getOrDefault(ChangeFlag.UPDATE, new JsonArray());
                if (Ut.isNotNil((JsonArray)added)) {
                    combine.addAll(added);
                }
                return Ux.future((Object)combine);
            });
        });
    }

    public Future<JsonArray> uploadAsync(JsonArray data) {
        JsonObject params = this.uploadParams(data);
        return this.uploadAsync(data, params);
    }

    private JsonObject uploadParams(JsonArray data) {
        String sigma = Ut.valueString((JsonArray)data, (String)"sigma");
        String directory = Ut.valueString((JsonArray)data, (String)"directory");
        String updatedBy = Ut.valueString((JsonArray)data, (String)"updatedBy");
        JsonObject params = new JsonObject();
        params.put("sigma", (Object)sigma);
        params.put("directory", (Object)directory);
        params.put("updatedBy", (Object)updatedBy);
        return params;
    }

    public Future<JsonArray> uploadAsync(JsonArray data, JsonObject params) {
        if (Ut.isNil((JsonArray)data)) {
            return Ux.futureA();
        }
        return At.fileDir(data, params).compose(normalized -> {
            Ut.valueToString((JsonArray)normalized, (String[])new String[]{"metadata"});
            List attachments = Ux.fromJson((JsonArray)normalized, XAttachment.class);
            return Ux.Jooq.on(XAttachmentDao.class).insertJAsync(attachments).compose(At::fileUpload).compose(this::outAsync);
        });
    }

    public Future<JsonArray> updateAsync(JsonArray attachmentJ, boolean active) {
        Ut.valueToString((JsonArray)attachmentJ, (String[])new String[]{"metadata"});
        Ut.itJArray((JsonArray)attachmentJ).forEach(attachment -> {
            attachment.put("updatedAt", (Object)Instant.now());
            attachment.put("active", (Object)active);
        });
        List attachments = Ux.fromJson((JsonArray)attachmentJ, XAttachment.class);
        return Ux.Jooq.on(XAttachmentDao.class).updateAsyncJ(attachments).compose(Fn.ofJArray((String[])new String[]{"metadata"}));
    }

    public Future<JsonArray> removeAsync(JsonObject condition) {
        return Ux.Jooq.on(XAttachmentDao.class).fetchJAsync(condition).compose(attachments -> this.removeAsyncInternal(condition, (JsonArray)attachments));
    }

    public Future<JsonArray> purgeAsync(JsonArray attachment) {
        JsonObject criteria = new JsonObject();
        criteria.put("key,i", (Object)Ut.toJArray((Set)Ut.valueSetString((JsonArray)attachment, (String)"key")));
        return this.removeAsyncInternal(criteria, attachment);
    }

    public Future<JsonArray> fetchAsync(JsonObject condition) {
        return this.fetchAsyncInternal(condition).compose(this::outAsync);
    }

    public Future<Buffer> downloadAsync(Set<String> keys) {
        JsonObject condition = new JsonObject();
        condition.put("key,i", (Object)Ut.toJArray(keys));
        return this.fetchAsyncInternal(condition).compose(At::fileDownload);
    }

    public Future<Buffer> downloadAsync(String key) {
        JsonObject condition = new JsonObject();
        condition.put("key", (Object)key);
        At.LOG.File.info(LOGGER, "Fetch Operation, condition: {0}", new Object[]{condition});
        return Ux.Jooq.on(XAttachmentDao.class).fetchJOneAsync(condition).compose(At::fileDownload);
    }

    private Future<JsonArray> fetchAsyncInternal(JsonObject condition) {
        At.LOG.File.info(LOGGER, "Fetch Operation, condition: {0}", new Object[]{condition});
        return Ux.Jooq.on(XAttachmentDao.class).fetchJAsync(condition);
    }

    private Future<JsonArray> outAsync(JsonArray files) {
        Set keys = Ut.valueSetString((JsonArray)files, (String)"directoryId");
        return Ux.channel(ExIo.class, () -> files, io -> io.dirBy(keys).compose(map -> {
            Ut.itJArray((JsonArray)files).forEach(file -> {
                String directoryId = file.getString("directoryId");
                if (Ut.isNotNil((String)directoryId)) {
                    JsonObject directoryJ = map.getOrDefault(directoryId, new JsonObject());
                    JsonObject visitJ = Ut.elementSubset((JsonObject)directoryJ, (String[])new String[]{"visitRole", "visitGroup", "visit", "visitMode"});
                    JsonArray visitMode = Ut.valueJArray((JsonObject)visitJ, (String)"visitMode");
                    if (visitMode.contains((Object)"w") && !visitMode.contains((Object)"x")) {
                        visitMode.add((Object)"x");
                        visitJ.put("visitMode", (Object)visitMode);
                    }
                    file.mergeIn(visitJ, true);
                }
            });
            return Ux.future((Object)files);
        })).compose(Fn.ofJArray((String[])new String[]{"metadata"})).compose(attachments -> {
            Ut.itJArray((JsonArray)attachments).forEach(file -> file.put("directory", (Object)Boolean.FALSE));
            return Ux.future((Object)attachments);
        });
    }

    private Future<JsonArray> removeAsyncInternal(JsonObject condition, JsonArray attachments) {
        At.LOG.File.info(LOGGER, "Remove Operation, condition: {0}", new Object[]{condition});
        return Ux.Jooq.on(XAttachmentDao.class).deleteByAsync(condition).compose(removed -> At.fileRemove(attachments)).compose(this::outAsync);
    }
}

