/*
 * Decompiled with CFR 0.152.
 */
package io.horizon.spi.feature;

import cn.vertxup.ambient.domain.tables.daos.XActivityRuleDao;
import cn.vertxup.ambient.domain.tables.pojos.XActivityRule;
import io.horizon.spi.environment.Indent;
import io.horizon.spi.feature.Valve;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ambient.cv.em.TubeType;
import io.vertx.tp.ambient.refine.At;
import io.vertx.tp.ambient.uca.darkly.Tube;
import io.vertx.tp.error._501IndentMissingException;
import io.vertx.tp.ke.refine.Ke;
import io.vertx.up.atom.Refer;
import io.vertx.up.fn.Fn;
import io.vertx.up.uca.wffs.Formula;
import io.vertx.up.uca.wffs.Regulation;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;

public class ValueRule
implements Valve {
    public Future<JsonObject> execAsync(JsonObject data, JsonObject config) {
        JsonObject criteria = Ut.valueJObject((JsonObject)data, (String)"criteria");
        if (Ux.irNil((JsonObject)criteria)) {
            return Ux.future((Object)data);
        }
        At.LOG.Tabb.info(this.getClass(), "Qr condition for ActivityRule: {0}", new Object[]{criteria.encode()});
        Refer ruleRef = new Refer();
        Refer inputRef = new Refer();
        Refer serialRef = new Refer();
        return Ke.umUser((JsonObject)data).compose(arg_0 -> ((Refer)inputRef).future(arg_0)).compose(normalized -> Ux.Jooq.on(XActivityRuleDao.class).fetchAsync(criteria)).compose(arg_0 -> ((Refer)ruleRef).future(arg_0)).compose(rules -> this.ruleSerial((List<XActivityRule>)rules).compose(arg_0 -> ((Refer)serialRef).future(arg_0)).compose(nil -> Ux.future((Object)rules))).compose(this::ruleRegulation).compose(regulation -> regulation.run(((JsonObject)inputRef.get()).copy(), this.ruleFn((List)ruleRef.get(), (ConcurrentMap)serialRef.get())));
    }

    private ConcurrentMap<String, Function<JsonObject, Future<JsonObject>>> ruleFn(List<XActivityRule> ruleList, ConcurrentMap<String, Queue<String>> serialMap) {
        ConcurrentHashMap<String, Function<JsonObject, Future<JsonObject>>> ruleMap = new ConcurrentHashMap<String, Function<JsonObject, Future<JsonObject>>>();
        ruleList.sort(Comparator.comparing(XActivityRule::getRuleOrder));
        ruleList.forEach(rule -> {
            Boolean isLog;
            Boolean bl = isLog = Objects.isNull(rule.getLogging()) ? Boolean.FALSE : rule.getLogging();
            if (isLog.booleanValue()) {
                String code = this.ruleIndent((XActivityRule)rule);
                Queue serialQ = (Queue)serialMap.get(code);
                String serial = (String)serialQ.poll();
                ruleMap.put(rule.getKey(), params -> {
                    TubeType type = (TubeType)Ut.toEnum(rule::getType, TubeType.class, null);
                    Tube tube = Tube.instance(type);
                    params.put("traceSerial", (Object)serial);
                    return tube.traceAsync((JsonObject)params, (XActivityRule)rule);
                });
            } else {
                ruleMap.put(rule.getKey(), Ux::future);
            }
        });
        return ruleMap;
    }

    private Future<ConcurrentMap<String, Queue<String>>> ruleSerial(List<XActivityRule> ruleList) {
        if (ruleList.isEmpty()) {
            return Ux.future(new ConcurrentHashMap());
        }
        ConcurrentHashMap serialQ = new ConcurrentHashMap();
        ConcurrentHashMap<String, Integer> serialC = new ConcurrentHashMap<String, Integer>();
        ruleList.forEach(rule -> {
            String code = this.ruleIndent((XActivityRule)rule);
            Integer counter = (Integer)serialC.get(code);
            if (Objects.isNull(counter)) {
                serialC.put(code, 1);
            } else {
                counter = counter + 1;
                serialC.put(code, counter);
            }
        });
        XActivityRule rule2 = ruleList.iterator().next();
        serialC.forEach((code, size) -> serialQ.put(code, Ux.channel(Indent.class, ConcurrentLinkedQueue::new, stub -> stub.indent(code, rule2.getSigma(), size.intValue()))));
        return Fn.combineM(serialQ).compose(Ux::future);
    }

    private String ruleIndent(XActivityRule rule) {
        JsonObject config = Ut.toJObject((String)rule.getRuleConfig());
        JsonObject initData = Ut.valueJObject((JsonObject)config, (String)"data");
        String code = initData.getString("indent");
        if (Ut.isNil((String)code)) {
            throw new _501IndentMissingException(this.getClass(), initData);
        }
        return code;
    }

    private Future<Regulation> ruleRegulation(List<XActivityRule> rules) {
        Regulation regulation = new Regulation();
        rules.stream().filter(rule -> Objects.nonNull(rule.getRuleExpression())).forEach(rule -> {
            Formula formula = new Formula(rule.getKey());
            JsonObject tpl = Ut.toJObject((String)rule.getRuleTpl());
            formula.bind(rule.getRuleExpression(), tpl);
            Class hookerCls = Ut.clazz((String)rule.getHookComponent(), null);
            if (Objects.nonNull(hookerCls)) {
                JsonObject hookerConfig = Ut.toJObject((String)rule.getHookConfig());
                formula.bind(hookerCls, hookerConfig);
            }
            formula.name(rule.getRuleName());
            regulation.add(formula);
        });
        return Ux.future((Object)regulation);
    }
}

