/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.ambient.init;

import cn.vertxup.ambient.service.file.DocBStub;
import cn.vertxup.ambient.service.file.DocBuilder;
import io.horizon.uca.log.Annal;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ambient.atom.AtConfig;
import io.vertx.tp.ambient.init.AtConfiguration;
import io.vertx.tp.ambient.refine.At;
import io.vertx.tp.ke.refine.Ke;
import io.vertx.up.uca.di.DiPlugin;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;

public class AtInit {
    private static final Annal LOGGER = Annal.get(AtInit.class);
    private static final DiPlugin PLUGIN = DiPlugin.create(AtInit.class);

    public static Future<Boolean> initDocument(Vertx vertx) {
        return Ke.mapApp(appJ -> {
            AtConfig config = AtConfiguration.getConfig();
            boolean disabled = Ut.isNil((String)config.getFileIntegration());
            if (disabled) {
                At.LOG.Init.info(LOGGER, "Document Platform Disabled !!", new Object[0]);
                return Ux.futureF();
            }
            DocBStub docStub = (DocBStub)PLUGIN.createComponent(DocBuilder.class);
            String appId = Ut.valueString((JsonObject)appJ, (String)"key");
            return docStub.initialize(appId, config.getFileIntegration()).compose(initialized -> {
                At.LOG.Init.info(LOGGER, "AppId = {0}, Directory Size = {1}", new Object[]{appId, String.valueOf(initialized.size())});
                return Ux.futureT();
            });
        }, result -> Ux.future((Object)result.stream().allMatch(item -> item)));
    }
}

